/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui.po;

import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.FindBy;
import org.xwiki.test.ui.po.BaseElement;
import org.xwiki.test.ui.po.InlinePage;
import org.xwiki.test.ui.po.editor.ClassEditPage;
import org.xwiki.test.ui.po.editor.ObjectEditPage;
import org.xwiki.test.ui.po.editor.RightsEditPage;
import org.xwiki.test.ui.po.editor.WYSIWYGEditPage;
import org.xwiki.test.ui.po.editor.WikiEditPage;

public class BasePage
extends BaseElement {
    @FindBy(id="xwikimaincontainer")
    private WebElement mainContainerDiv;
    @FindBy(id="contentmenu")
    private WebElement contentMenuBar;
    @FindBy(id="tmEdit")
    private WebElement editMenu;

    public String getPageTitle() {
        return this.getDriver().getTitle();
    }

    public String getPageURL() {
        return this.getDriver().getCurrentUrl();
    }

    public String getMetaDataValue(String metaName) {
        return this.getDriver().findElement(By.xpath((String)("//meta[@name='" + metaName + "']"))).getAttribute("content");
    }

    public boolean isAuthenticated() {
        return !BasePage.getUtil().findElementsWithoutWaiting(this.getDriver(), By.id((String)"tmUser")).isEmpty();
    }

    public boolean isNewDocument() {
        return (Boolean)((JavascriptExecutor)this.getDriver()).executeScript("return XWiki.docisnew", new Object[0]);
    }

    protected void clickContentMenuTopEntry(String id) {
        new Actions(this.getDriver()).moveToElement(this.contentMenuBar).perform();
        this.getDriver().findElement(By.xpath((String)("//div[@id='" + id + "']//strong"))).click();
    }

    protected void clickContentMenuEditSubMenuEntry(String id) {
        new Actions(this.getDriver()).moveToElement(this.contentMenuBar).moveToElement(this.editMenu).perform();
        this.getDriver().findElement(By.xpath((String)("//a[@id='" + id + "']"))).click();
    }

    public void edit() {
        this.clickContentMenuTopEntry("tmEdit");
    }

    public String getEditURL() {
        return this.getDriver().findElement(By.xpath((String)"//div[@id='tmEdit']//a")).getAttribute("href");
    }

    public WikiEditPage editWiki() {
        this.clickContentMenuEditSubMenuEntry("tmEditWiki");
        return new WikiEditPage();
    }

    public WYSIWYGEditPage editWYSIWYG() {
        this.clickContentMenuEditSubMenuEntry("tmEditWysiwyg");
        return new WYSIWYGEditPage();
    }

    public <T extends InlinePage> T editInline() {
        this.clickContentMenuEditSubMenuEntry("tmEditInline");
        return this.createInlinePage();
    }

    protected <T extends InlinePage> T createInlinePage() {
        return (T)new InlinePage();
    }

    public RightsEditPage editRights() {
        this.clickContentMenuEditSubMenuEntry("tmEditRights");
        return new RightsEditPage();
    }

    public ObjectEditPage editObjects() {
        this.clickContentMenuEditSubMenuEntry("tmEditObject");
        return new ObjectEditPage();
    }

    public ClassEditPage editClass() {
        this.clickContentMenuEditSubMenuEntry("tmEditClass");
        return new ClassEditPage();
    }

    public void sendKeys(CharSequence ... keys) {
        this.mainContainerDiv.sendKeys(keys);
    }

    public BasePage waitUntilPageIsLoaded() {
        this.waitUntilElementIsVisible(By.id((String)"footerglobal"));
        return this;
    }
}

