/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui.po.editor;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.test.ui.po.BaseElement;
import org.xwiki.test.ui.po.ViewPage;
import org.xwiki.test.ui.po.editor.PreviewableEditPage;
import org.xwiki.test.ui.po.editor.wysiwyg.AttachedImageSelectPane;
import org.xwiki.test.ui.po.editor.wysiwyg.EditorElement;
import org.xwiki.test.ui.po.editor.wysiwyg.TableConfigPane;

public class WYSIWYGEditPage
extends PreviewableEditPage {
    @FindBy(id="xwikidoctitleinput")
    private WebElement titleField;
    @FindBy(name="action_save")
    private WebElement saveAndViewSubmit;
    @FindBy(name="parent")
    private WebElement parentInput;
    private final EditorElement editor = new EditorElement("content");

    public static WYSIWYGEditPage gotoPage(String space, String page) {
        BaseElement.getUtil().gotoPage(space, page, "edit", "editor=wysiwyg");
        return new WYSIWYGEditPage();
    }

    public String getDocumentTitle() {
        return this.titleField.getAttribute("value");
    }

    public ViewPage save() {
        this.saveAndViewSubmit.submit();
        return new ViewPage();
    }

    public String getContent() {
        if ("xwiki/1.0".equals(this.getSyntaxId())) {
            String windowHandle = this.getDriver().getWindowHandle();
            this.getDriver().switchTo().frame("mce_editor_0");
            String content = this.getDriver().findElement(By.id((String)"mceSpanFonts")).getText();
            this.getDriver().switchTo().window(windowHandle);
            return content;
        }
        return this.editor.getRichTextArea().getText();
    }

    public EditorElement getContentEditor() {
        return this.editor;
    }

    public AttachedImageSelectPane insertAttachedImage() {
        this.editor.getMenuBar().clickImageMenu();
        return this.editor.getMenuBar().clickInsertAttachedImageMenu();
    }

    public TableConfigPane insertTable() {
        this.editor.getMenuBar().clickTableMenu();
        return this.editor.getMenuBar().clickInsertTableMenu();
    }

    public String getParent() {
        return this.parentInput.getAttribute("value");
    }
}

