/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui;

import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.WebDriver;
import org.xwiki.test.integration.XWikiExecutor;
import org.xwiki.test.ui.TestUtils;
import org.xwiki.test.ui.WebDriverFactory;

public class PersistentTestContext {
    private static final String BROWSER_NAME_SYSTEM_PROPERTY = System.getProperty("browser", "*firefox");
    private final XWikiExecutor executor;
    private final WebDriver driver;
    private final TestUtils util = new TestUtils();
    private WebDriverFactory webDriverFactory = new WebDriverFactory();
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public PersistentTestContext() throws Exception {
        this(new XWikiExecutor(0));
        this.executor.start();
    }

    public PersistentTestContext(XWikiExecutor executor) throws Exception {
        this.executor = executor;
        this.driver = this.webDriverFactory.createWebDriver(BROWSER_NAME_SYSTEM_PROPERTY);
        this.getUtil().setDriverImplicitWait(this.driver);
    }

    public PersistentTestContext(PersistentTestContext toClone) {
        this.executor = toClone.executor;
        this.driver = toClone.driver;
        this.properties.putAll(toClone.properties);
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public TestUtils getUtil() {
        return this.util;
    }

    public void shutdown() throws Exception {
        this.driver.quit();
        this.executor.stop();
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public PersistentTestContext getUnstoppable() {
        return new PersistentTestContext(this){

            @Override
            public void shutdown() {
            }
        };
    }
}

