/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui.po;

import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.Select;
import org.xwiki.test.ui.po.BaseElement;

public class LiveTableElement
extends BaseElement {
    private String livetableId;

    public LiveTableElement(String livetableId) {
        this.livetableId = livetableId;
    }

    public boolean isReady() {
        Object result = this.executeJavascript("return Element.hasClassName('" + this.livetableId + "-ajax-loader','hidden')", new Object[0]);
        return result instanceof Boolean ? (Boolean)result : false;
    }

    public void waitUntilReady() {
        long t1 = System.currentTimeMillis();
        while (System.currentTimeMillis() - t1 < (long)LiveTableElement.getUtil().getTimeout() * 1000L) {
            if (this.isReady()) {
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        throw new TimeoutException("Livetable isn't ready after the timeout has expired.");
    }

    public boolean hasColumn(String columnTitle) {
        List<WebElement> elements = LiveTableElement.getUtil().findElementsWithoutWaiting(this.getDriver(), By.xpath((String)("//th[contains(@class, 'xwiki-livetable-display-header-text') and normalize-space(.) = '" + columnTitle + "']")));
        return elements.size() > 0;
    }

    public void filterColumn(String inputId, String filterValue) {
        this.executeJavascript("return $('" + this.livetableId + "-ajax-loader').removeClassName('hidden')", new Object[0]);
        WebElement element = this.getDriver().findElement(By.id((String)inputId));
        if ("select".equals(element.getTagName())) {
            new Select(element).selectByVisibleText(filterValue);
        } else {
            element.clear();
            element.sendKeys(new CharSequence[]{filterValue});
        }
        this.waitUntilReady();
    }

    public String getFilterValue(String inputId) {
        return this.getDriver().findElement(By.id((String)inputId)).getAttribute("value");
    }

    public int getColumnIndex(String columnTitle) {
        WebElement liveTable = this.getDriver().findElement(By.id((String)this.livetableId));
        String escapedColumnTitle = columnTitle.replace("\\", "\\\\").replace("'", "\\'");
        String columnXPath = "//thead[@class = 'xwiki-livetable-display-header']//th[normalize-space(.) = '%s']";
        WebElement column = liveTable.findElement(By.xpath((String)String.format(columnXPath, escapedColumnTitle)));
        return ((Long)((JavascriptExecutor)this.getDriver()).executeScript("return arguments[0].cellIndex;", new Object[]{column})).intValue();
    }

    public boolean hasRow(String columnTitle, String columnValue) {
        String escapedColumnValue = columnValue.replace("\\", "\\\\").replace("'", "\\'");
        String cellXPath = "//tr/td[position() = %s and . = '%s']";
        WebElement liveTableBody = this.getDriver().findElement(By.id((String)(this.livetableId + "-display")));
        return liveTableBody.findElements(By.xpath((String)String.format(cellXPath, this.getColumnIndex(columnTitle) + 1, escapedColumnValue))).size() > 0;
    }

    public int getRowCount() {
        WebElement liveTableBody = this.getDriver().findElement(By.id((String)(this.livetableId + "-display")));
        return liveTableBody.findElements(By.xpath((String)"tr")).size();
    }

    public void waitUntilRowCountGreaterThan(final int minimalExpectedRowCount) {
        final By by = By.xpath((String)("//tbody[@id = '" + this.livetableId + "-display']//tr"));
        LiveTableElement.getUtil().waitUntilCondition(new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return driver.findElements(by).size() >= minimalExpectedRowCount;
            }
        });
    }
}

