/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui.po;

import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.AjaxElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.xwiki.test.ui.PersistentTestContext;
import org.xwiki.test.ui.TestUtils;

public class BaseElement {
    private static PersistentTestContext context;

    public static void setContext(PersistentTestContext context) {
        BaseElement.context = context;
    }

    public BaseElement() {
        AjaxElementLocatorFactory finder = new AjaxElementLocatorFactory(this.getDriver(), BaseElement.getUtil().getTimeout());
        PageFactory.initElements((ElementLocatorFactory)finder, (Object)this);
    }

    protected WebDriver getDriver() {
        return context.getDriver();
    }

    protected static TestUtils getUtil() {
        return context.getUtil();
    }

    public void waitUntilElementIsVisible(By locator) {
        this.waitUntilElementsAreVisible(new By[]{locator}, true);
    }

    public void waitUntilElementsAreVisible(final By[] locators, final boolean all) {
        BaseElement.getUtil().waitUntilCondition(new ExpectedCondition<WebElement>(){

            public WebElement apply(WebDriver driver) {
                WebElement element = null;
                for (int i = 0; i < locators.length; ++i) {
                    try {
                        element = driver.findElement(locators[i]);
                    }
                    catch (NotFoundException e) {
                        if (!all) continue;
                        return null;
                    }
                    try {
                        if (element.isDisplayed()) {
                            if (all) continue;
                            return element;
                        }
                        if (!all) continue;
                        return null;
                    }
                    catch (StaleElementReferenceException e) {
                        return null;
                    }
                }
                return element;
            }
        });
    }

    public void waitUntilElementDisappears(final By locator) {
        BaseElement.getUtil().waitUntilCondition(new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                try {
                    WebElement element = driver.findElement(locator);
                    return !element.isDisplayed();
                }
                catch (NotFoundException e) {
                    return Boolean.TRUE;
                }
                catch (StaleElementReferenceException e) {
                    return Boolean.TRUE;
                }
            }
        });
    }

    public void makeElementVisible(By locator) {
        this.makeElementVisible(this.getDriver().findElement(locator));
    }

    public void makeElementVisible(WebElement element) {
        this.executeJavascript("arguments[0].style.visibility='visible'", element);
    }

    public void waitUntilElementHasAttributeValue(final By locator, final String attributeName, final String expectedValue) {
        BaseElement.getUtil().waitUntilCondition(new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                try {
                    WebElement element = driver.findElement(locator);
                    return expectedValue.equals(element.getAttribute(attributeName));
                }
                catch (NotFoundException e) {
                    return false;
                }
                catch (StaleElementReferenceException e) {
                    return false;
                }
            }
        });
    }

    public void waitUntilElementEndsWithAttributeValue(final By locator, final String attributeName, final String expectedValue) {
        BaseElement.getUtil().waitUntilCondition(new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                try {
                    WebElement element = driver.findElement(locator);
                    return element.getAttribute(attributeName).endsWith(expectedValue);
                }
                catch (NotFoundException e) {
                    return false;
                }
                catch (StaleElementReferenceException e) {
                    return false;
                }
            }
        });
    }

    public void waitUntilElementHasTextContent(final By locator, final String expectedValue) {
        BaseElement.getUtil().waitUntilCondition(new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                WebElement element = driver.findElement(locator);
                return expectedValue.equals(element.getText());
            }
        });
    }

    public Object executeJavascript(String javascript, Object ... arguments) {
        return ((JavascriptExecutor)this.getDriver()).executeScript(javascript, arguments);
    }

    public void makeConfirmDialogSilent(boolean accept) {
        String script = String.format("window.confirm = function() { return %s; }", accept);
        ((JavascriptExecutor)this.getDriver()).executeScript(script, new Object[0]);
    }

    public void makeAlertDialogSilent() {
        ((JavascriptExecutor)this.getDriver()).executeScript("window.alert = function() { return true; }", new Object[0]);
    }

    public void waitForNotificationErrorMessage(String message) {
        this.waitForNotificationMessage("error", message);
    }

    public void waitForNotificationWarningMessage(String message) {
        this.waitForNotificationMessage("warning", message);
    }

    public void waitForNotificationSuccessMessage(String message) {
        this.waitForNotificationMessage("done", message);
    }

    private void waitForNotificationMessage(String level, String message) {
        By notificationMessageLocator = By.xpath((String)String.format("//div[contains(@class,'xnotification-%s') and contains(., '%s')]", level, message));
        this.waitUntilElementIsVisible(notificationMessageLocator);
        try {
            BaseElement.getUtil().findElementWithoutWaiting(this.getDriver(), notificationMessageLocator).click();
        }
        catch (WebDriverException e) {
            // empty catch block
        }
    }
}

