/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui.po;

import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.FindBys;
import org.xwiki.test.ui.po.BaseElement;
import org.xwiki.test.ui.po.ConfirmationPage;
import org.xwiki.test.ui.po.CopyPage;
import org.xwiki.test.ui.po.CreatePagePage;
import org.xwiki.test.ui.po.CreateSpacePage;
import org.xwiki.test.ui.po.InlinePage;
import org.xwiki.test.ui.po.LoginPage;
import org.xwiki.test.ui.po.RegistrationPage;
import org.xwiki.test.ui.po.editor.ClassEditPage;
import org.xwiki.test.ui.po.editor.ObjectEditPage;
import org.xwiki.test.ui.po.editor.RightsEditPage;
import org.xwiki.test.ui.po.editor.WYSIWYGEditPage;
import org.xwiki.test.ui.po.editor.WikiEditPage;

public class BasePage
extends BaseElement {
    @FindBy(id="xwikimaincontainer")
    private WebElement mainContainerDiv;
    @FindBy(id="contentmenu")
    private WebElement contentMenuBar;
    @FindBy(id="tmEdit")
    private WebElement editMenu;
    @FindBy(id="tmCreatePage")
    private WebElement createPageMenuLink;
    @FindBy(id="tmCreateSpace")
    private WebElement createSpaceMenuLink;
    @FindBy(id="tmCreate")
    private WebElement createMenu;
    @FindBy(id="tmActionCopy")
    private WebElement copyPageLink;
    @FindBy(id="tmActionDelete")
    private WebElement deletePageLink;
    @FindBy(id="tmWatchDocument")
    private WebElement watchDocumentLink;
    @FindBy(id="tmPage")
    private WebElement pageMenu;
    @FindBys(value={@FindBy(id="tmRegister"), @FindBy(tagName="a")})
    private WebElement registerLink;
    @FindBys(value={@FindBy(id="tmLogin"), @FindBy(tagName="a")})
    private WebElement loginLink;
    @FindBys(value={@FindBy(id="tmLogout"), @FindBy(tagName="a")})
    private WebElement logoutLink;
    @FindBys(value={@FindBy(id="tmUser"), @FindBy(tagName="a")})
    private WebElement userLink;
    @FindBy(id="document-title")
    private WebElement documentTitle;
    @FindBy(id="tmWatchSpace")
    private WebElement watchSpaceLink;
    @FindBy(id="tmSpace")
    private WebElement spaceMenu;

    public String getPageTitle() {
        return this.getDriver().getTitle();
    }

    public String getPageURL() {
        return this.getDriver().getCurrentUrl();
    }

    public String getMetaDataValue(String metaName) {
        return this.getDriver().findElement(By.xpath((String)("//meta[@name='" + metaName + "']"))).getAttribute("content");
    }

    public boolean isAuthenticated() {
        return !BasePage.getUtil().findElementsWithoutWaiting(this.getDriver(), By.id((String)"tmUser")).isEmpty();
    }

    public boolean isNewDocument() {
        return (Boolean)((JavascriptExecutor)this.getDriver()).executeScript("return XWiki.docisnew", new Object[0]);
    }

    protected void clickContentMenuTopEntry(String id) {
        new Actions(this.getDriver()).moveToElement(this.contentMenuBar).perform();
        this.getDriver().findElement(By.xpath((String)("//div[@id='" + id + "']//strong"))).click();
    }

    protected void clickContentMenuEditSubMenuEntry(String id) {
        new Actions(this.getDriver()).moveToElement(this.contentMenuBar).moveToElement(this.editMenu).perform();
        this.getDriver().findElement(By.xpath((String)("//a[@id='" + id + "']"))).click();
    }

    public void edit() {
        this.clickContentMenuTopEntry("tmEdit");
    }

    public String getEditURL() {
        return this.getDriver().findElement(By.xpath((String)"//div[@id='tmEdit']//a")).getAttribute("href");
    }

    public WikiEditPage editWiki() {
        this.clickContentMenuEditSubMenuEntry("tmEditWiki");
        return new WikiEditPage();
    }

    public WYSIWYGEditPage editWYSIWYG() {
        this.clickContentMenuEditSubMenuEntry("tmEditWysiwyg");
        return new WYSIWYGEditPage();
    }

    public <T extends InlinePage> T editInline() {
        this.clickContentMenuEditSubMenuEntry("tmEditInline");
        return this.createInlinePage();
    }

    protected <T extends InlinePage> T createInlinePage() {
        return (T)new InlinePage();
    }

    public RightsEditPage editRights() {
        this.clickContentMenuEditSubMenuEntry("tmEditRights");
        return new RightsEditPage();
    }

    public ObjectEditPage editObjects() {
        this.clickContentMenuEditSubMenuEntry("tmEditObject");
        return new ObjectEditPage();
    }

    public ClassEditPage editClass() {
        this.clickContentMenuEditSubMenuEntry("tmEditClass");
        return new ClassEditPage();
    }

    public void sendKeys(CharSequence ... keys) {
        this.mainContainerDiv.sendKeys(keys);
    }

    public BasePage waitUntilPageIsLoaded() {
        this.waitUntilElementIsVisible(By.id((String)"footerglobal"));
        return this;
    }

    public CreatePagePage createPage() {
        new Actions(this.getDriver()).moveToElement(this.createMenu).perform();
        this.createPageMenuLink.click();
        return new CreatePagePage();
    }

    public CreateSpacePage createSpace() {
        new Actions(this.getDriver()).moveToElement(this.createMenu).perform();
        this.createSpaceMenuLink.click();
        return new CreateSpacePage();
    }

    public CopyPage copy() {
        new Actions(this.getDriver()).moveToElement(this.pageMenu).perform();
        this.copyPageLink.click();
        return new CopyPage();
    }

    public ConfirmationPage delete() {
        new Actions(this.getDriver()).moveToElement(this.pageMenu).perform();
        this.deletePageLink.click();
        return new ConfirmationPage();
    }

    public boolean canDelete() {
        if (BasePage.getUtil().hasElement(By.xpath((String)"//div[@id='tmPage']//span[@class='menuarrow']"))) {
            new Actions(this.getDriver()).moveToElement(this.pageMenu).perform();
            return BasePage.getUtil().hasElement(By.id((String)"tmActionDelete"));
        }
        return false;
    }

    public void watchDocument() {
        new Actions(this.getDriver()).moveToElement(this.pageMenu).perform();
        this.watchDocumentLink.click();
    }

    public boolean hasLoginLink() {
        return !BasePage.getUtil().findElementsWithoutWaiting(this.getDriver(), By.id((String)"tmLogin")).isEmpty();
    }

    public LoginPage login() {
        this.loginLink.click();
        return new LoginPage();
    }

    public String getCurrentUser() {
        return this.userLink.getText();
    }

    public void logout() {
        this.logoutLink.click();
        BasePage.getUtil().recacheSecretToken();
    }

    public RegistrationPage register() {
        this.registerLink.click();
        return new RegistrationPage();
    }

    public String getDocumentTitle() {
        return this.documentTitle.getText();
    }

    public void watchSpace() {
        new Actions(this.getDriver()).moveToElement(this.spaceMenu).perform();
        this.watchSpaceLink.click();
    }

    public String getPageMenuLink() {
        return this.pageMenu.findElement(By.xpath((String)".//a[contains(@class, 'tme')]")).getAttribute("href");
    }
}

