/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui.po.editor;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.test.ui.po.BasePage;
import org.xwiki.test.ui.po.FormElement;
import org.xwiki.test.ui.po.ViewPage;
import org.xwiki.test.ui.po.editor.ClassPropertyEditPane;
import org.xwiki.test.ui.po.editor.DatabaseListClassEditElement;
import org.xwiki.test.ui.po.editor.NumberClassEditElement;
import org.xwiki.test.ui.po.editor.StaticListClassEditElement;

public class ClassEditPage
extends BasePage {
    @FindBy(name="action_saveandcontinue")
    private WebElement saveandcontinue;
    @FindBy(name="action_propupdate")
    private WebElement saveandview;
    @FindBy(name="action_cancel")
    private WebElement cancel;
    @FindBy(id="propupdate")
    private WebElement propertyForm;
    @FindBy(id="propname")
    private WebElement propertyNameField;
    @FindBy(id="proptype")
    private WebElement propertyTypeField;
    @FindBy(name="action_propadd")
    private WebElement propertySubmit;
    private FormElement form;

    public static ClassEditPage gotoPage(String space, String page) {
        ClassEditPage.getUtil().gotoPage(space, page, "edit", "editor=class");
        return new ClassEditPage();
    }

    public ClassPropertyEditPane addProperty(String propertyName, String propertyType) {
        this.addPropertyWithoutWaiting(propertyName, propertyType);
        return this.getPropertyEditPane(propertyName);
    }

    public void addPropertyWithoutWaiting(String propertyName, String propertyType) {
        this.getForm().setFieldValue(this.propertyNameField, propertyName);
        this.getForm().setFieldValue(this.propertyTypeField, propertyType);
        this.propertySubmit.click();
    }

    public void deleteProperty(String propertyName) {
        By propertyLocator = By.id((String)("xproperty_" + propertyName));
        WebElement propertyContainer = this.getDriver().findElement(propertyLocator);
        WebElement deleteLink = propertyContainer.findElement(By.className((String)"delete"));
        deleteLink.click();
        this.waitUntilElementIsVisible(By.className((String)"xdialog-box-confirmation"));
        this.getDriver().findElement(By.cssSelector((String)".xdialog-box-confirmation input[value='Yes']")).click();
        this.waitUntilElementDisappears(propertyLocator);
    }

    private FormElement getForm() {
        if (this.form == null) {
            this.form = new FormElement(this.propertyForm);
        }
        return this.form;
    }

    public ClassPropertyEditPane getPropertyEditPane(String propertyName) {
        return new ClassPropertyEditPane(this.getForm(), propertyName).expand();
    }

    public DatabaseListClassEditElement getDatabaseListClassEditElement(String propertyName) {
        return (DatabaseListClassEditElement)new DatabaseListClassEditElement(this.getForm(), propertyName).expand();
    }

    public StaticListClassEditElement getStaticListClassEditElement(String propertyName) {
        return (StaticListClassEditElement)new StaticListClassEditElement(this.getForm(), propertyName).expand();
    }

    public NumberClassEditElement getNumberClassEditElement(String propertyName) {
        return (NumberClassEditElement)new NumberClassEditElement(this.getForm(), propertyName).expand();
    }

    public void clickSaveAndContinue() {
        this.saveandcontinue.click();
        this.waitForNotificationSuccessMessage("Saved");
    }

    public ViewPage clickSaveAndView() {
        this.saveandview.click();
        return new ViewPage();
    }

    public ViewPage clickCancel() {
        this.cancel.click();
        return new ViewPage();
    }
}

