/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.packager;

import com.xpn.xwiki.tool.backup.Importer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.velocity.VelocityComponent;
import org.xwiki.tool.packager.ArtifactItem;
import org.xwiki.tool.packager.SkinArtifactItem;

public class PackageMojo
extends AbstractMojo {
    protected MavenProject project;
    protected List<ArtifactRepository> remoteRepos;
    protected MavenProjectBuilder mavenProjectBuilder;
    protected ArtifactFactory factory;
    protected ArtifactResolver resolver;
    private File tmpXarDirectory;
    private File outputPackageDirectory;
    private File outputClassesDirectory;
    private File databaseDirectory;
    private ArtifactRepository local;
    private ArtifactMetadataSource metadataSource;
    private VelocityComponent velocity;
    private List<SkinArtifactItem> skinArtifactItems;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Expanding Jetty Resources ...");
        Artifact jettyArtifact = this.resolveJettyArtifact();
        this.unzip(jettyArtifact.getFile(), this.outputPackageDirectory);
        this.getLog().info((CharSequence)"Expanding WAR dependencies ...");
        File webappsDirectory = new File(this.outputPackageDirectory, "webapps");
        for (Map.Entry<String, Artifact> warArtifactEntry : this.resolveWarArtifacts().entrySet()) {
            this.getLog().info((CharSequence)("  ... Unzipping WAR: " + warArtifactEntry.getValue().getFile()));
            this.unzip(warArtifactEntry.getValue().getFile(), new File(webappsDirectory, warArtifactEntry.getKey()));
        }
        this.getLog().info((CharSequence)"Copying JAR dependencies ...");
        File xwikiWebappDirectory = new File(webappsDirectory, "xwiki");
        File webInfDirectory = new File(xwikiWebappDirectory, "WEB-INF");
        File libDirectory = new File(webInfDirectory, "lib");
        this.createDirectory(libDirectory);
        for (Artifact artifact : this.resolveJarArtifacts()) {
            this.getLog().info((CharSequence)("  ... Copying JAR: " + artifact.getFile()));
            this.copyFile(artifact.getFile(), libDirectory);
        }
        this.getLog().info((CharSequence)"Copying Java Classes ...");
        File classesDirectory = new File(webInfDirectory, "classes");
        if (this.outputClassesDirectory.exists()) {
            this.copyDirectory(this.outputClassesDirectory, classesDirectory);
        }
        this.getLog().info((CharSequence)"Copying Configuration files ...");
        this.generateConfigurationFiles(webInfDirectory);
        this.getLog().info((CharSequence)"Copying HSQLDB JDBC Driver JAR ...");
        Artifact hsqldbArtifact = this.resolveHSQLDBArtifact();
        this.copyFile(hsqldbArtifact.getFile(), libDirectory);
        this.getLog().info((CharSequence)"Copying Skins ...");
        File skinsDirectory = new File(xwikiWebappDirectory, "skins");
        if (this.skinArtifactItems != null) {
            for (SkinArtifactItem skinArtifactItem : this.skinArtifactItems) {
                Artifact skinArtifact = this.resolveArtifactItem(skinArtifactItem);
                this.unzip(skinArtifact.getFile(), skinsDirectory);
            }
        } else {
            Artifact colibriArtifact = this.resolveArtifact("org.xwiki.platform", "xwiki-platform-colibri", this.project.getVersion(), "zip");
            this.unzip(colibriArtifact.getFile(), skinsDirectory);
        }
        this.getLog().info((CharSequence)"Import XAR dependencies ...");
        this.importXARs(webInfDirectory);
    }

    private Artifact resolveArtifactItem(ArtifactItem artifactItem) throws MojoExecutionException {
        String version = artifactItem.getVersion();
        String type = artifactItem.getType();
        if (version == null || type == null) {
            String key;
            Map artifacts = this.project.getArtifactMap();
            if (artifacts.containsKey(key = ArtifactUtils.versionlessKey((String)artifactItem.getGroupId(), (String)artifactItem.getArtifactId()))) {
                if (version == null) {
                    version = ((Artifact)artifacts.get(key)).getVersion();
                }
                if (type == null) {
                    type = ((Artifact)artifacts.get(key)).getType();
                }
            } else {
                if (version == null) {
                    version = this.project.getVersion();
                }
                if (type == null) {
                    type = "jar";
                }
            }
        }
        Artifact artifact = this.factory.createArtifact(artifactItem.getGroupId(), artifactItem.getArtifactId(), version, "", type);
        this.resolveArtifact(artifact);
        return artifact;
    }

    private void generateConfigurationFiles(File configurationFileTargetDirectory) throws MojoExecutionException {
        VelocityContext context = this.createVelocityContext();
        Artifact configurationResourcesArtifact = this.factory.createArtifact("org.xwiki.platform", "xwiki-platform-tool-configuration-resources", this.project.getVersion(), "", "jar");
        this.resolveArtifact(configurationResourcesArtifact);
        configurationFileTargetDirectory.mkdirs();
        try {
            JarEntry entry;
            JarInputStream jarInputStream = new JarInputStream(new FileInputStream(configurationResourcesArtifact.getFile()));
            while ((entry = jarInputStream.getNextJarEntry()) != null) {
                if (!entry.getName().endsWith(".vm")) continue;
                String fileName = entry.getName().replace(".vm", "");
                File outputFile = new File(configurationFileTargetDirectory, fileName);
                OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(outputFile));
                this.getLog().info((CharSequence)("Writing config file: " + outputFile));
                this.velocity.getEngine().evaluate((Context)context, (Writer)writer, "", IOUtils.toString((InputStream)jarInputStream));
                writer.close();
                jarInputStream.closeEntry();
            }
            jarInputStream.close();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to extract configuration files", e);
        }
    }

    private void importXARs(File webInfDirectory) throws MojoExecutionException {
        Set<Artifact> xarArtifacts = this.resolveXARs();
        if (!xarArtifacts.isEmpty()) {
            Importer importer = new Importer();
            System.setProperty("hibernate.connection.url", "jdbc:hsqldb:file:" + this.databaseDirectory + "/xwiki_db;shutdown=true");
            for (Artifact xarArtifact : xarArtifacts) {
                File xarTargetDirectory = new File(this.tmpXarDirectory, xarArtifact.getArtifactId());
                this.unzip(xarArtifact.getFile(), xarTargetDirectory);
                try {
                    this.getLog().info((CharSequence)("  ... Importing XAR: " + xarArtifact.getFile()));
                    importer.importDocuments(xarTargetDirectory, "xwiki", new File(webInfDirectory, "hibernate.cfg.xml"));
                }
                catch (Exception e) {
                    throw new MojoExecutionException(String.format("Failed to import XAR [%s]", xarArtifact.toString()), e);
                }
            }
            this.copyDirectory(this.databaseDirectory, new File(this.outputPackageDirectory, "database"));
        }
    }

    private Set<Artifact> resolveXARs() throws MojoExecutionException {
        HashSet<Artifact> xarArtifacts = new HashSet<Artifact>();
        Set artifacts = this.project.getArtifacts();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                if (!artifact.getType().equals("xar")) continue;
                xarArtifacts.add(artifact);
                this.resolveArtifact(artifact);
            }
        }
        return xarArtifacts;
    }

    private Artifact resolveHSQLDBArtifact() throws MojoExecutionException {
        Artifact hsqldbArtifact = null;
        Set artifacts = this.project.getArtifacts();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                if (!artifact.getType().equals("jar") || !artifact.getGroupId().equals("hsqldb") || !artifact.getArtifactId().equals("hsqldb")) continue;
                hsqldbArtifact = artifact;
                break;
            }
        }
        if (hsqldbArtifact == null) {
            hsqldbArtifact = this.factory.createArtifact("hsqldb", "hsqldb", "1.8.0.7", "", "jar");
        }
        if (hsqldbArtifact == null) {
            throw new MojoExecutionException("Failed to locate the HSQLDB artifact in either the project dependency list or using the specific [hsqldb:hsqldb] artifact name");
        }
        this.resolveArtifact(hsqldbArtifact);
        return hsqldbArtifact;
    }

    private Artifact resolveJettyArtifact() throws MojoExecutionException {
        Artifact jettyArtifact = null;
        Set artifacts = this.project.getArtifacts();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                if (!artifact.getType().equals("zip") || !artifact.getArtifactId().equals("xwiki-platform-tool-jetty-resources")) continue;
                jettyArtifact = artifact;
                break;
            }
        }
        if (jettyArtifact == null) {
            jettyArtifact = this.factory.createArtifact("org.xwiki.platform", "xwiki-platform-tool-jetty-resources", this.project.getVersion(), "", "zip");
        }
        if (jettyArtifact == null) {
            throw new MojoExecutionException("Failed to locate the Jetty artifact in either the project dependency list or using the specific [xwiki-platform-tool-jetty-resources] artifact name");
        }
        this.resolveArtifact(jettyArtifact);
        return jettyArtifact;
    }

    private Map<String, Artifact> resolveWarArtifacts() throws MojoExecutionException {
        HashMap<String, Artifact> warArtifacts = new HashMap<String, Artifact>();
        Set artifacts = this.project.getArtifacts();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                if (!artifact.getType().equals("war")) continue;
                String id = artifact.getArtifactId().equals("xwiki-platform-web") ? "xwiki" : (artifact.getArtifactId().equals("xwiki-platform-tool-rootwebapp") ? "root" : artifact.getArtifactId());
                warArtifacts.put(id, artifact);
                break;
            }
        }
        if (warArtifacts.isEmpty()) {
            warArtifacts.put("xwiki", this.factory.createArtifact("org.xwiki.platform", "xwiki-platform-web", this.project.getVersion(), "", "war"));
            warArtifacts.put("root", this.factory.createArtifact("org.xwiki.platform", "xwiki-platform-tool-rootwebapp", this.project.getVersion(), "", "war"));
        }
        if (!warArtifacts.isEmpty()) {
            for (Artifact warArtifact : warArtifacts.values()) {
                this.resolveArtifact(warArtifact);
            }
        } else {
            throw new MojoExecutionException("Failed to locate any XWiki WAR artifact in either the project dependency list or using the specific [xwiki-platform-web]/[xwiki-platform-tool-rootwebapp] artifact names");
        }
        return warArtifacts;
    }

    private Collection<Artifact> resolveJarArtifacts() throws MojoExecutionException {
        HashSet<Artifact> jarArtifacts = new HashSet<Artifact>();
        Set artifacts = this.project.getArtifacts();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                if (!artifact.getType().equals("jar")) continue;
                jarArtifacts.add(artifact);
                this.resolveArtifact(artifact);
            }
        }
        jarArtifacts.addAll(this.getMandatoryJarArtifacts());
        return this.resolveTransitively(jarArtifacts);
    }

    private Set<Artifact> getMandatoryJarArtifacts() throws MojoExecutionException {
        HashSet<Artifact> mandatoryTopLevelArtifacts = new HashSet<Artifact>();
        mandatoryTopLevelArtifacts.add(this.factory.createArtifact("org.xwiki.platform", "xwiki-platform-oldcore", this.project.getVersion(), null, "jar"));
        mandatoryTopLevelArtifacts.add(this.factory.createArtifact("org.xwiki.platform", "xwiki-platform-skin-skinx", this.project.getVersion(), null, "jar"));
        mandatoryTopLevelArtifacts.add(this.factory.createArtifact("org.xwiki.platform", "xwiki-platform-wysiwyg-server", this.project.getVersion(), null, "jar"));
        mandatoryTopLevelArtifacts.add(this.factory.createArtifact("org.xwiki.platform", "xwiki-platform-wysiwyg-client", this.project.getVersion(), null, "jar"));
        mandatoryTopLevelArtifacts.add(this.factory.createArtifact("org.xwiki.platform", "xwiki-platform-webdav-server", this.project.getVersion(), null, "jar"));
        mandatoryTopLevelArtifacts.add(this.factory.createArtifact("org.xwiki.platform", "xwiki-platform-rest-server", this.project.getVersion(), null, "jar"));
        mandatoryTopLevelArtifacts.add(this.factory.createArtifact("org.xwiki.platform", "xwiki-platform-gwt-api", this.project.getVersion(), null, "jar"));
        mandatoryTopLevelArtifacts.add(this.factory.createArtifact("org.xwiki.commons", "xwiki-commons-logging-logback", this.project.getVersion(), null, "jar"));
        MavenProject pomProject = this.getTopLevelPOMProject();
        mandatoryTopLevelArtifacts.add(this.factory.createArtifact("org.slf4j", "jcl-over-slf4j", this.getDependencyManagementVersion(pomProject, "org.slf4j", "jcl-over-slf4j"), null, "jar"));
        mandatoryTopLevelArtifacts.add(this.factory.createArtifact("org.slf4j", "log4j-over-slf4j", this.getDependencyManagementVersion(pomProject, "org.slf4j", "log4j-over-slf4j"), null, "jar"));
        return mandatoryTopLevelArtifacts;
    }

    private Set<Artifact> resolveTransitively(Set<Artifact> artifacts) throws MojoExecutionException {
        HashSet<Artifact> resolvedArtifacts = new HashSet<Artifact>();
        try {
            AndArtifactFilter filter = new AndArtifactFilter();
            filter.add((ArtifactFilter)new ScopeArtifactFilter("runtime"));
            filter.add((ArtifactFilter)new ExcludesArtifactFilter(Arrays.asList("org.apache.xmlgraphic:batik-js", "commons-logging:commons-logging", "commons-logging:commons-logging-api", "log4j:log4j")));
            ArtifactResolutionResult arr = this.resolver.resolveTransitively(artifacts, this.project.getArtifact(), this.project.getManagedVersionMap(), this.local, this.remoteRepos, this.metadataSource, (ArtifactFilter)filter);
            resolvedArtifacts.addAll(arr.getArtifacts());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to resolve mandatory artifacts", e);
        }
        return resolvedArtifacts;
    }

    private MavenProject getTopLevelPOMProject() throws MojoExecutionException {
        MavenProject pomProject;
        Artifact pomArtifact = this.factory.createArtifact("org.xwiki.commons", "xwiki-commons", this.project.getVersion(), "", "pom");
        try {
            pomProject = this.mavenProjectBuilder.buildFromRepository(pomArtifact, this.remoteRepos, this.local);
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException(String.format("Failed to build project for [%s]", pomArtifact), (Exception)((Object)e));
        }
        return pomProject;
    }

    private String getDependencyManagementVersion(MavenProject project, String groupId, String artifactId) throws MojoExecutionException {
        for (Object dependencyObject : project.getDependencyManagement().getDependencies()) {
            Dependency dependency = (Dependency)dependencyObject;
            if (!dependency.getGroupId().equals(groupId) || !dependency.getArtifactId().equals(artifactId)) continue;
            return dependency.getVersion();
        }
        throw new MojoExecutionException(String.format("Failed to find artifact [%s:%s] in dependency management for [%s]", groupId, artifactId, project.toString()));
    }

    private void createDirectory(File directory) {
        if (!directory.exists()) {
            directory.mkdirs();
        }
    }

    private void copyDirectory(File sourceDirectory, File targetDirectory) throws MojoExecutionException {
        this.createDirectory(targetDirectory);
        try {
            FileUtils.copyDirectoryStructureIfModified((File)sourceDirectory, (File)targetDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Failed to copy directory [%] to [%]", sourceDirectory, targetDirectory), (Exception)e);
        }
    }

    private void copyFile(File source, File targetDirectory) throws MojoExecutionException {
        try {
            FileUtils.copyFileToDirectoryIfModified((File)source, (File)targetDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Failed to copy file [%] to [%]", source, targetDirectory), (Exception)e);
        }
    }

    private void unzip(File source, File targetDirectory) throws MojoExecutionException {
        this.createDirectory(targetDirectory);
        try {
            ZipUnArchiver unArchiver = new ZipUnArchiver();
            unArchiver.enableLogging((Logger)new ConsoleLogger(3, "Package"));
            unArchiver.setSourceFile(source);
            unArchiver.setDestDirectory(targetDirectory);
            unArchiver.setOverwrite(true);
            unArchiver.extract();
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Error unpacking file [%s] into [%s]", source, targetDirectory), e);
        }
    }

    private void resolveArtifact(Artifact artifact) throws MojoExecutionException {
        try {
            this.resolver.resolve(artifact, this.remoteRepos, this.local);
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Failed to resolve artifact [%s]", artifact), e);
        }
    }

    private Artifact resolveArtifact(String groupId, String artifactId, String version, String type) throws MojoExecutionException {
        Artifact artifact = this.factory.createArtifact(groupId, artifactId, version, "", type);
        this.resolveArtifact(artifact);
        return artifact;
    }

    private VelocityContext createVelocityContext() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.getDefaultConfigurationProperties());
        Properties projectProperties = this.project.getProperties();
        for (Object key : projectProperties.keySet()) {
            properties.put(key.toString(), projectProperties.get(key).toString());
        }
        VelocityContext context = new VelocityContext((Map)properties);
        String inceptionYear = this.project.getInceptionYear();
        String year = new SimpleDateFormat("yyyy").format(new Date());
        if (StringUtils.isEmpty((String)inceptionYear)) {
            inceptionYear = year;
        }
        context.put("project", (Object)this.project);
        context.put("presentYear", (Object)year);
        if (inceptionYear.equals(year)) {
            context.put("projectTimespan", (Object)year);
        } else {
            context.put("projectTimespan", (Object)(inceptionYear + "-" + year));
        }
        return context;
    }

    private Properties getDefaultConfigurationProperties() {
        Properties props = new Properties();
        props.setProperty("xwikiDbConnectionUrl", "jdbc:hsqldb:file:database/xwiki_db;shutdown=true");
        props.setProperty("xwikiDbConnectionUsername", "sa");
        props.setProperty("xwikiDbConnectionPassword", "");
        props.setProperty("xwikiDbConnectionDriverClass", "org.hsqldb.jdbcDriver");
        props.setProperty("xwikiDbDialect", "org.hibernate.dialect.HSQLDialect");
        props.setProperty("xwikiDbHbmXwiki", "xwiki.hbm.xml");
        props.setProperty("xwikiDbHbmFeeds", "feeds.hbm.xml");
        props.setProperty("xwikiCfgPlugins", "com.xpn.xwiki.plugin.skinx.JsSkinExtensionPlugin,\\        com.xpn.xwiki.plugin.skinx.JsSkinFileExtensionPlugin,\\        com.xpn.xwiki.plugin.skinx.CssSkinExtensionPlugin,\\        com.xpn.xwiki.plugin.skinx.CssSkinFileExtensionPlugin,\\        com.xpn.xwiki.plugin.skinx.LinkExtensionPlugin");
        props.setProperty("xwikiCfgVirtual", "0");
        props.setProperty("xwikiCfgVirtualUsepath", "0");
        props.setProperty("xwikiCfgEditCommentMandatory", "0");
        props.setProperty("xwikiCfgDefaultSkin", "colibri");
        props.setProperty("xwikiCfgDefaultBaseSkin", "colibri");
        props.setProperty("xwikiCfgEncoding", "UTF-8");
        return props;
    }
}

