/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.packager;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.tool.backup.Importer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.repository.RepositorySystem;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.aether.RepositorySystemSession;
import org.xwiki.tool.packager.ArtifactItem;
import org.xwiki.tool.packager.SkinArtifactItem;
import org.xwiki.velocity.internal.log.SLF4JLogChute;

public class PackageMojo
extends AbstractMojo {
    private File tmpXarDirectory;
    private File outputPackageDirectory;
    private File outputClassesDirectory;
    private File databaseDirectory;
    protected MavenProject project;
    protected ProjectBuilder projectBuilder;
    protected RepositorySystem repositorySystem;
    private RepositorySystemSession repositorySystemSession;
    protected ArtifactRepository localRepository;
    protected List<ArtifactRepository> remoteRepositories;
    private String importUser;
    private String platformVersion;
    private List<SkinArtifactItem> skinArtifactItems;
    private Map<String, String> contextPathMapping;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Using platform version: " + this.getXWikiPlatformVersion()));
        this.getLog().info((CharSequence)"Expanding Jetty Resources ...");
        this.expandJettyDistribution();
        this.getLog().info((CharSequence)"Expanding WAR dependencies ...");
        File webappsDirectory = new File(this.outputPackageDirectory, "webapps");
        for (Artifact warArtifact : this.resolveWarArtifacts()) {
            this.getLog().info((CharSequence)("  ... Unzipping WAR: " + warArtifact.getFile()));
            this.unzip(warArtifact.getFile(), new File(webappsDirectory, this.getContextPath(warArtifact)));
        }
        this.getLog().info((CharSequence)"Copying JAR dependencies ...");
        File xwikiWebappDirectory = new File(webappsDirectory, "xwiki");
        File webInfDirectory = new File(xwikiWebappDirectory, "WEB-INF");
        File libDirectory = new File(webInfDirectory, "lib");
        this.createDirectory(libDirectory);
        for (Artifact artifact : this.resolveJarArtifacts()) {
            this.getLog().info((CharSequence)("  ... Copying JAR: " + artifact.getFile()));
            this.copyFile(artifact.getFile(), libDirectory);
        }
        this.getLog().info((CharSequence)"Copying Java Classes ...");
        File classesDirectory = new File(webInfDirectory, "classes");
        if (this.outputClassesDirectory.exists()) {
            this.copyDirectory(this.outputClassesDirectory, classesDirectory);
        }
        this.getLog().info((CharSequence)"Copying Configuration files ...");
        this.generateConfigurationFiles(webInfDirectory);
        this.getLog().info((CharSequence)"Copying HSQLDB JDBC Driver JAR ...");
        Artifact hsqldbArtifact = this.resolveHSQLDBArtifact();
        this.copyFile(hsqldbArtifact.getFile(), libDirectory);
        this.getLog().info((CharSequence)"Copying Skins ...");
        File skinsDirectory = new File(xwikiWebappDirectory, "skins");
        if (this.skinArtifactItems != null) {
            for (SkinArtifactItem skinArtifactItem : this.skinArtifactItems) {
                Artifact skinArtifact = this.resolveArtifactItem(skinArtifactItem);
                this.unzip(skinArtifact.getFile(), skinsDirectory);
            }
        } else {
            Artifact colibriArtifact = this.resolveArtifact("org.xwiki.platform", "xwiki-platform-colibri", this.getXWikiPlatformVersion(), "zip");
            this.unzip(colibriArtifact.getFile(), skinsDirectory);
        }
        this.getLog().info((CharSequence)"Extracting SmartClient ...");
        String smartGWTVersion = this.project.getProperties().getProperty("smartgwt.version");
        Artifact smartGWTArtifact = this.resolveArtifact("com.smartgwt", "smartgwt", smartGWTVersion, "jar");
        File smartGWTOutputDirectory = new File(this.project.getBuild().getDirectory(), "smartgwt");
        this.unzip(smartGWTArtifact.getFile(), smartGWTOutputDirectory);
        File smartClientDirectory = new File(xwikiWebappDirectory, "resources/js/smartclient");
        this.copyDirectory(new File(smartGWTOutputDirectory, "com/smartclient/public/sc"), smartClientDirectory);
        this.copyDirectory(new File(smartGWTOutputDirectory, "com/smartclient/theme/enterprise/public/sc/skins"), new File(smartClientDirectory, "skins"));
        this.getLog().info((CharSequence)String.format("Import XAR dependencies %s...", this.importUser == null ? "as a backup pack" : "using user [" + this.importUser + "]"));
        this.importXARs(webInfDirectory);
    }

    private void expandJettyDistribution() throws MojoExecutionException {
        Artifact jettyArtifact = this.resolveJettyArtifact();
        this.unzip(jettyArtifact.getFile(), this.outputPackageDirectory);
        VelocityContext context = this.createVelocityContext();
        Collection startFiles = org.apache.commons.io.FileUtils.listFiles((File)this.outputPackageDirectory, (IOFileFilter)new WildcardFileFilter("start_xwiki*.*"), null);
        Velocity.setProperty((String)"runtime.log.logsystem", (Object)new SLF4JLogChute());
        Velocity.init();
        for (File startFile : startFiles) {
            this.getLog().info((CharSequence)String.format("  Replacing variables in [%s]...", startFile));
            try {
                String content = org.apache.commons.io.FileUtils.readFileToString((File)startFile);
                OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(startFile));
                Velocity.evaluate((Context)context, (Writer)writer, (String)"", (String)content);
                writer.close();
            }
            catch (Exception e) {
                throw new MojoExecutionException(String.format("Failed to process start shell script [%s]", startFile), e);
            }
        }
    }

    private Artifact resolveArtifactItem(ArtifactItem artifactItem) throws MojoExecutionException {
        String version = artifactItem.getVersion();
        String type = artifactItem.getType();
        if (version == null || type == null) {
            String key;
            Map artifacts = this.project.getArtifactMap();
            if (artifacts.containsKey(key = ArtifactUtils.versionlessKey((String)artifactItem.getGroupId(), (String)artifactItem.getArtifactId()))) {
                if (version == null) {
                    version = ((Artifact)artifacts.get(key)).getVersion();
                }
                if (type == null) {
                    type = ((Artifact)artifacts.get(key)).getType();
                }
            } else {
                if (version == null) {
                    version = this.getXWikiPlatformVersion();
                }
                if (type == null) {
                    type = "jar";
                }
            }
        }
        Artifact artifact = this.repositorySystem.createArtifact(artifactItem.getGroupId(), artifactItem.getArtifactId(), version, "", type);
        this.resolveArtifact(artifact);
        return artifact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateConfigurationFiles(File configurationFileTargetDirectory) throws MojoExecutionException {
        VelocityContext context = this.createVelocityContext();
        Artifact configurationResourcesArtifact = this.repositorySystem.createArtifact("org.xwiki.platform", "xwiki-platform-tool-configuration-resources", this.getXWikiPlatformVersion(), "", "jar");
        this.resolveArtifact(configurationResourcesArtifact);
        configurationFileTargetDirectory.mkdirs();
        try {
            JarInputStream jarInputStream = new JarInputStream(new FileInputStream(configurationResourcesArtifact.getFile()));
            try {
                JarEntry entry;
                while ((entry = jarInputStream.getNextJarEntry()) != null) {
                    if (!entry.getName().endsWith(".vm")) continue;
                    String fileName = entry.getName().replace(".vm", "");
                    File outputFile = new File(configurationFileTargetDirectory, fileName);
                    OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(outputFile));
                    this.getLog().info((CharSequence)("Writing config file: " + outputFile));
                    Velocity.init();
                    Velocity.evaluate((Context)context, (Writer)writer, (String)"", (String)IOUtils.toString((InputStream)jarInputStream));
                    writer.close();
                    jarInputStream.closeEntry();
                }
            }
            finally {
                jarInputStream.close();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to extract configuration files", e);
        }
    }

    private void importXARs(File webInfDirectory) throws MojoExecutionException {
        Set<Artifact> xarArtifacts = this.resolveXARs();
        if (!xarArtifacts.isEmpty()) {
            XWikiContext xcontext;
            Importer importer = new Importer();
            System.setProperty("hibernate.connection.url", "jdbc:hsqldb:file:" + this.databaseDirectory + "/xwiki_db;shutdown=true");
            try {
                xcontext = importer.createXWikiContext("xwiki", new File(webInfDirectory, "hibernate.cfg.xml"));
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to create context to import XAR files", e);
            }
            for (Artifact xarArtifact : xarArtifacts) {
                this.getLog().info((CharSequence)("  ... Importing XAR file: " + xarArtifact.getFile()));
                try {
                    int nb = importer.importXAR(xarArtifact.getFile(), this.importUser, xcontext);
                    this.getLog().info((CharSequence)("  .... Imported " + nb + " documents"));
                }
                catch (Exception e) {
                    throw new MojoExecutionException(String.format("Failed to import XAR [%s]", xarArtifact.toString()), e);
                }
            }
            try {
                importer.shutdownHSQLDB(xcontext);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to shutdown hsqldb database", e);
            }
            File dataDir = new File(this.outputPackageDirectory, "data");
            this.copyDirectory(this.databaseDirectory, new File(dataDir, "database"));
            try {
                importer.disposeXWikiContext(xcontext);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to dispose XWiki context", e);
            }
        }
    }

    private Set<Artifact> resolveXARs() throws MojoExecutionException {
        HashSet<Artifact> xarArtifacts = new HashSet<Artifact>();
        Set artifacts = this.project.getArtifacts();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                if (!artifact.getType().equals("xar")) continue;
                xarArtifacts.add(artifact);
                this.resolveArtifact(artifact);
            }
        }
        return xarArtifacts;
    }

    private Artifact resolveHSQLDBArtifact() throws MojoExecutionException {
        Artifact hsqldbArtifact = null;
        Set artifacts = this.project.getArtifacts();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                if (!artifact.getType().equals("jar") || !artifact.getGroupId().equals("org.hsqldb") || !artifact.getArtifactId().equals("hsqldb")) continue;
                hsqldbArtifact = artifact;
                break;
            }
        }
        if (hsqldbArtifact == null) {
            hsqldbArtifact = this.repositorySystem.createArtifact("org.hsqldb", "hsqldb", "2.2.9", "", "jar");
        }
        if (hsqldbArtifact == null) {
            throw new MojoExecutionException("Failed to locate the HSQLDB artifact in either the project dependency list or using the specific [hsqldb:hsqldb] artifact name");
        }
        this.resolveArtifact(hsqldbArtifact);
        return hsqldbArtifact;
    }

    private Artifact resolveJettyArtifact() throws MojoExecutionException {
        Artifact jettyArtifact = null;
        Set artifacts = this.project.getArtifacts();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                if (!artifact.getType().equals("zip") || !artifact.getArtifactId().equals("xwiki-platform-tool-jetty-resources")) continue;
                jettyArtifact = artifact;
                break;
            }
        }
        if (jettyArtifact == null) {
            jettyArtifact = this.repositorySystem.createArtifact("org.xwiki.platform", "xwiki-platform-tool-jetty-resources", this.getXWikiPlatformVersion(), "", "zip");
        }
        if (jettyArtifact == null) {
            throw new MojoExecutionException("Failed to locate the Jetty artifact in either the project dependency list or using the specific [xwiki-platform-tool-jetty-resources] artifact name");
        }
        this.resolveArtifact(jettyArtifact);
        return jettyArtifact;
    }

    private Collection<Artifact> resolveWarArtifacts() throws MojoExecutionException {
        ArrayList<Artifact> warArtifacts = new ArrayList<Artifact>();
        for (Artifact artifact : this.project.getArtifacts()) {
            if (!artifact.getType().equals("war")) continue;
            warArtifacts.add(artifact);
        }
        if (warArtifacts.isEmpty()) {
            warArtifacts.add(this.repositorySystem.createArtifact("org.xwiki.platform", "xwiki-platform-web", this.getXWikiPlatformVersion(), "", "war"));
            warArtifacts.add(this.repositorySystem.createArtifact("org.xwiki.platform", "xwiki-platform-tool-rootwebapp", this.getXWikiPlatformVersion(), "", "war"));
        }
        for (Artifact warArtifact : warArtifacts) {
            this.resolveArtifact(warArtifact);
        }
        return warArtifacts;
    }

    private String getContextPath(Artifact warArtifact) {
        String contextPath = this.getContextPathMapping().get(warArtifact.getArtifactId());
        if (contextPath == null) {
            contextPath = warArtifact.getArtifactId().equals("xwiki-platform-web") ? "xwiki" : (warArtifact.getArtifactId().equals("xwiki-platform-tool-rootwebapp") ? "root" : warArtifact.getArtifactId());
        }
        return contextPath;
    }

    private Map<String, String> getContextPathMapping() {
        if (this.contextPathMapping == null) {
            this.contextPathMapping = Collections.emptyMap();
        }
        return this.contextPathMapping;
    }

    private Collection<Artifact> resolveJarArtifacts() throws MojoExecutionException {
        Set<Artifact> mys = this.resolveTransitively(Collections.singleton(this.repositorySystem.createArtifact("org.xwiki.platform", "xwiki-platform-chart-renderer", "5.0-SNAPSHOT", "jar")));
        Set artifactsToResolve = this.project.getArtifacts();
        artifactsToResolve.addAll(this.getMandatoryJarArtifacts());
        Set<Artifact> resolvedArtifacts = this.resolveTransitively(artifactsToResolve);
        HashSet<Artifact> jarArtifacts = new HashSet<Artifact>();
        for (Artifact artifact : resolvedArtifacts) {
            if (!artifact.getType().equals("jar")) continue;
            jarArtifacts.add(artifact);
        }
        return jarArtifacts;
    }

    private Set<Artifact> getMandatoryJarArtifacts() throws MojoExecutionException {
        HashSet<Artifact> mandatoryTopLevelArtifacts = new HashSet<Artifact>();
        mandatoryTopLevelArtifacts.add(this.repositorySystem.createArtifact("org.xwiki.platform", "xwiki-platform-oldcore", this.getXWikiPlatformVersion(), null, "jar"));
        mandatoryTopLevelArtifacts.add(this.repositorySystem.createArtifact("org.xwiki.platform", "xwiki-platform-skin-skinx", this.getXWikiPlatformVersion(), null, "jar"));
        mandatoryTopLevelArtifacts.add(this.repositorySystem.createArtifact("org.xwiki.platform", "xwiki-platform-wysiwyg-server", this.getXWikiPlatformVersion(), null, "jar"));
        mandatoryTopLevelArtifacts.add(this.repositorySystem.createArtifact("org.xwiki.platform", "xwiki-platform-webdav-server", this.getXWikiPlatformVersion(), null, "jar"));
        mandatoryTopLevelArtifacts.add(this.repositorySystem.createArtifact("org.xwiki.platform", "xwiki-platform-rest-server", this.getXWikiPlatformVersion(), null, "jar"));
        mandatoryTopLevelArtifacts.add(this.repositorySystem.createArtifact("org.xwiki.platform", "xwiki-platform-gwt-api", this.getXWikiPlatformVersion(), null, "jar"));
        mandatoryTopLevelArtifacts.add(this.repositorySystem.createArtifact("org.xwiki.platform", "xwiki-platform-uiextension-api", this.getXWikiPlatformVersion(), null, "jar"));
        mandatoryTopLevelArtifacts.add(this.repositorySystem.createArtifact("org.xwiki.platform", "xwiki-platform-localization-script", this.getXWikiPlatformVersion(), null, "jar"));
        mandatoryTopLevelArtifacts.add(this.repositorySystem.createArtifact("org.xwiki.platform", "xwiki-platform-localization-source-legacy", this.getXWikiPlatformVersion(), null, "jar"));
        mandatoryTopLevelArtifacts.add(this.repositorySystem.createArtifact("org.xwiki.platform", "xwiki-platform-security-bridge", this.getXWikiPlatformVersion(), null, "jar"));
        mandatoryTopLevelArtifacts.add(this.repositorySystem.createArtifact("org.xwiki.platform", "xwiki-platform-url-standard", this.getXWikiPlatformVersion(), null, "jar"));
        mandatoryTopLevelArtifacts.add(this.repositorySystem.createArtifact("org.xwiki.commons", "xwiki-commons-logging-logback", this.getXWikiCommonsVersion(), "compile", "jar"));
        MavenProject pomProject = this.getTopLevelPOMProject();
        mandatoryTopLevelArtifacts.add(this.repositorySystem.createArtifact("org.slf4j", "jcl-over-slf4j", this.getDependencyManagementVersion(pomProject, "org.slf4j", "jcl-over-slf4j"), null, "jar"));
        mandatoryTopLevelArtifacts.add(this.repositorySystem.createArtifact("org.slf4j", "log4j-over-slf4j", this.getDependencyManagementVersion(pomProject, "org.slf4j", "log4j-over-slf4j"), null, "jar"));
        return mandatoryTopLevelArtifacts;
    }

    private Set<Artifact> resolveTransitively(Set<Artifact> artifacts) throws MojoExecutionException {
        AndArtifactFilter filter = new AndArtifactFilter(Arrays.asList(new ScopeArtifactFilter("runtime"), new ExcludesArtifactFilter(Arrays.asList("org.apache.xmlgraphic:batik-js", "commons-logging:commons-logging", "commons-logging:commons-logging-api", "log4j:log4j"))));
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(this.project.getArtifact()).setArtifactDependencies(artifacts).setCollectionFilter((ArtifactFilter)filter).setRemoteRepositories(this.remoteRepositories).setLocalRepository(this.localRepository).setManagedVersionMap(this.getManagedVersionMap()).setResolveRoot(false);
        ArtifactResolutionResult resolutionResult = this.repositorySystem.resolve(request);
        if (resolutionResult.hasExceptions()) {
            throw new MojoExecutionException(String.format("Failed to resolve artifacts [%s]", artifacts, resolutionResult.getExceptions().get(0)));
        }
        return resolutionResult.getArtifacts();
    }

    private Map<String, Artifact> getManagedVersionMap() throws MojoExecutionException {
        HashMap<String, Artifact> dependencyManagementMap = new HashMap<String, Artifact>();
        dependencyManagementMap.putAll(this.getPlatformPOMProject().getManagedVersionMap());
        dependencyManagementMap.putAll(this.project.getManagedVersionMap());
        return dependencyManagementMap;
    }

    private MavenProject getTopLevelPOMProject() throws MojoExecutionException {
        return this.getMavenProject(this.repositorySystem.createProjectArtifact("org.xwiki.commons", "xwiki-commons", this.getXWikiCommonsVersion()));
    }

    private MavenProject getPlatformPOMProject() throws MojoExecutionException {
        return this.getMavenProject(this.repositorySystem.createProjectArtifact("org.xwiki.platform", "xwiki-platform-core", this.getXWikiPlatformVersion()));
    }

    private MavenProject getMavenProject(Artifact artifact) throws MojoExecutionException {
        try {
            ProjectBuildingRequest request = new DefaultProjectBuildingRequest().setRepositorySession(this.repositorySystemSession).setProcessPlugins(false).setValidationLevel(0);
            ProjectBuildingResult result = this.projectBuilder.build(artifact, request);
            return result.getProject();
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException(String.format("Failed to build project for [%s]", artifact), (Exception)((Object)e));
        }
    }

    private String getXWikiCommonsVersion() {
        return this.project.getProperties().getProperty("commons.version", this.project.getVersion());
    }

    private String getXWikiPlatformVersion() {
        String version = this.platformVersion;
        if (version == null) {
            version = this.project.getVersion();
        }
        return version;
    }

    private String getDependencyManagementVersion(MavenProject project, String groupId, String artifactId) throws MojoExecutionException {
        for (Dependency dependencyObject : project.getDependencyManagement().getDependencies()) {
            Dependency dependency = dependencyObject;
            if (!dependency.getGroupId().equals(groupId) || !dependency.getArtifactId().equals(artifactId)) continue;
            return dependency.getVersion();
        }
        throw new MojoExecutionException(String.format("Failed to find artifact [%s:%s] in dependency management for [%s]", groupId, artifactId, project.toString()));
    }

    private void createDirectory(File directory) {
        if (!directory.exists()) {
            directory.mkdirs();
        }
    }

    private void copyDirectory(File sourceDirectory, File targetDirectory) throws MojoExecutionException {
        this.createDirectory(targetDirectory);
        try {
            FileUtils.copyDirectoryStructureIfModified((File)sourceDirectory, (File)targetDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Failed to copy directory [%] to [%]", sourceDirectory, targetDirectory), (Exception)e);
        }
    }

    private void copyFile(File source, File targetDirectory) throws MojoExecutionException {
        try {
            FileUtils.copyFileToDirectoryIfModified((File)source, (File)targetDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Failed to copy file [%] to [%]", source, targetDirectory), (Exception)e);
        }
    }

    private void unzip(File source, File targetDirectory) throws MojoExecutionException {
        this.createDirectory(targetDirectory);
        try {
            ZipUnArchiver unArchiver = new ZipUnArchiver();
            unArchiver.enableLogging((Logger)new ConsoleLogger(3, "Package"));
            unArchiver.setSourceFile(source);
            unArchiver.setDestDirectory(targetDirectory);
            unArchiver.setOverwrite(true);
            unArchiver.extract();
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Error unpacking file [%s] into [%s]", source, targetDirectory), e);
        }
    }

    private void resolveArtifact(Artifact artifact) throws MojoExecutionException {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(artifact).setRemoteRepositories(this.remoteRepositories).setLocalRepository(this.localRepository);
        ArtifactResolutionResult resolutionResult = this.repositorySystem.resolve(request);
        if (resolutionResult.hasExceptions()) {
            throw new MojoExecutionException(String.format("Failed to resolve artifact [%s]", artifact, resolutionResult.getExceptions().get(0)));
        }
    }

    private Artifact resolveArtifact(String groupId, String artifactId, String version, String type) throws MojoExecutionException {
        Artifact artifact = this.repositorySystem.createArtifact(groupId, artifactId, version, "", type);
        this.resolveArtifact(artifact);
        return artifact;
    }

    private VelocityContext createVelocityContext() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.getDefaultConfigurationProperties());
        Properties projectProperties = this.project.getProperties();
        for (Object key : projectProperties.keySet()) {
            properties.put(key.toString(), projectProperties.get(key).toString());
        }
        VelocityContext context = new VelocityContext((Map)properties);
        String inceptionYear = this.project.getInceptionYear();
        String year = new SimpleDateFormat("yyyy").format(new Date());
        if (StringUtils.isEmpty((String)inceptionYear)) {
            inceptionYear = year;
        }
        context.put("project", (Object)this.project);
        context.put("presentYear", (Object)year);
        if (inceptionYear.equals(year)) {
            context.put("projectTimespan", (Object)year);
        } else {
            context.put("projectTimespan", (Object)(inceptionYear + "-" + year));
        }
        return context;
    }

    private Properties getDefaultConfigurationProperties() {
        Properties props = new Properties();
        props.setProperty("xwikiDbConnectionUrl", "jdbc:hsqldb:file:${environment.permanentDirectory}/database/xwiki_db;shutdown=true");
        props.setProperty("xwikiDbConnectionUsername", "sa");
        props.setProperty("xwikiDbConnectionPassword", "");
        props.setProperty("xwikiDbConnectionDriverClass", "org.hsqldb.jdbcDriver");
        props.setProperty("xwikiDbDialect", "org.hibernate.dialect.HSQLDialect");
        props.setProperty("xwikiDbHbmXwiki", "xwiki.hbm.xml");
        props.setProperty("xwikiDbHbmFeeds", "feeds.hbm.xml");
        props.setProperty("xwikiCfgPlugins", "com.xpn.xwiki.plugin.skinx.JsSkinExtensionPlugin,\\        com.xpn.xwiki.plugin.skinx.JsSkinFileExtensionPlugin,\\        com.xpn.xwiki.plugin.skinx.CssSkinExtensionPlugin,\\        com.xpn.xwiki.plugin.skinx.CssSkinFileExtensionPlugin,\\        com.xpn.xwiki.plugin.skinx.LinkExtensionPlugin");
        props.setProperty("xwikiCfgVirtualUsepath", "1");
        props.setProperty("xwikiCfgEditCommentMandatory", "0");
        props.setProperty("xwikiCfgDefaultSkin", "colibri");
        props.setProperty("xwikiCfgDefaultBaseSkin", "colibri");
        props.setProperty("xwikiCfgEncoding", "UTF-8");
        props.setProperty("xwikiDataDir", "data");
        return props;
    }
}

