/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.utils;

public final class LogUtils {
    private static final String DEBUG_LEVEL = "debug";
    private static final String WARN_LEVEL = "warn";
    private static final String ERROR_LEVEL = "error";

    private LogUtils() {
    }

    public static void configureXWikiLogs() {
        String logLevel;
        String rootLogLevel = System.getProperty("org.slf4j.simpleLogger.defaultLogLevel");
        if (rootLogLevel == null) {
            return;
        }
        switch (rootLogLevel) {
            case "debug": 
            case "error": {
                logLevel = rootLogLevel;
                break;
            }
            default: {
                logLevel = WARN_LEVEL;
            }
        }
        System.setProperty("org.slf4j.simpleLogger.log.com.xpn", logLevel);
        System.setProperty("org.slf4j.simpleLogger.log.org.xwiki", logLevel);
        System.setProperty("org.slf4j.simpleLogger.log.org.hibernate", logLevel);
        System.setProperty("org.slf4j.simpleLogger.log.org.infinispan", logLevel);
        System.setProperty("org.slf4j.simpleLogger.log.org.reflections", logLevel);
        System.setProperty("org.slf4j.simpleLogger.log.org.hsqldb", logLevel);
        System.setProperty("org.slf4j.simpleLogger.log.hsqldb.db", logLevel);
        System.setProperty("org.slf4j.simpleLogger.log.org.xwiki.logging.logback", ERROR_LEVEL);
    }
}

