/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.tool.doc;

import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.tool.doc.AbstractDocumentMojo;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="attach")
public class AttachMojo
extends AbstractDocumentMojo {
    @Parameter(defaultValue="XWiki.Admin")
    private String author;
    @Parameter
    private File file;
    @Parameter
    private File[] files;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            XWikiDocument doc = this.loadFromXML(this.sourceDocument);
            List attachments = doc.getAttachmentList();
            if (this.file != null) {
                attachments.add(this.createAttachment(this.file, this.author));
            }
            if (this.files != null) {
                for (File file : this.files) {
                    attachments.add(this.createAttachment(file, this.author));
                }
            }
            doc.setAttachmentList(attachments);
            File outputFile = new File(this.getSpaceDirectory(this.outputDirectory, this.sourceDocument), this.sourceDocument.getName());
            this.writeToXML(doc, outputFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while attaching files on document [" + this.sourceDocument.getParentFile().getName() + "." + this.sourceDocument.getName() + "]", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XWikiAttachment createAttachment(File file, String author) throws MojoExecutionException {
        try {
            XWikiAttachment attachment = new XWikiAttachment();
            try (FileInputStream fis = new FileInputStream(file);){
                attachment.setContent((InputStream)fis);
            }
            attachment.setAuthor(author);
            attachment.setFilename(file.getName());
            return attachment;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while creating attachment for file [" + file.getName() + "]", e);
        }
    }
}

