/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tree;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.tree.AbstractTree;
import org.xwiki.tree.TreeNode;

public abstract class AbstractCompositeTree
extends AbstractTree {
    protected final Map<String, TreeNode> treeNodeByNodeType = new HashMap<String, TreeNode>();

    @Override
    public List<String> getChildren(String nodeId, int offset, int limit) {
        TreeNode treeNode = this.getTreeNode(nodeId);
        return treeNode != null ? treeNode.getChildren(nodeId, offset, limit) : null;
    }

    @Override
    public int getChildCount(String nodeId) {
        TreeNode treeNode = this.getTreeNode(nodeId);
        return treeNode != null ? treeNode.getChildCount(nodeId) : 0;
    }

    @Override
    public String getParent(String nodeId) {
        TreeNode treeNode = this.getTreeNode(nodeId);
        return treeNode != null ? treeNode.getParent(nodeId) : null;
    }

    protected TreeNode getTreeNode(String nodeId) {
        TreeNode treeNode = null;
        String[] parts = StringUtils.split((String)nodeId, (String)":", (int)2);
        if (parts != null && parts.length == 2 && (treeNode = this.treeNodeByNodeType.get(parts[0])) != null) {
            treeNode.getProperties().putAll(this.getProperties());
        }
        return treeNode;
    }
}

