/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tree.script;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.script.service.ScriptService;
import org.xwiki.tree.Tree;

@Component
@Named(value="tree")
@Singleton
public class TreeScriptService
implements ScriptService {
    @Inject
    private Logger logger;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> contextComponentManagerProvider;

    public Tree get(String roleHint) {
        ComponentManager contextComponentManager = (ComponentManager)this.contextComponentManagerProvider.get();
        if (contextComponentManager.hasComponent(Tree.class, roleHint)) {
            try {
                return (Tree)contextComponentManager.getInstance(Tree.class, roleHint);
            }
            catch (ComponentLookupException e) {
                this.logger.warn("Failed to load the specified tree component. Root cause is [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return null;
    }
}

