/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.uiextension.internal;

import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.wiki.WikiComponent;
import org.xwiki.component.wiki.WikiComponentScope;
import org.xwiki.context.Execution;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.ObjectReference;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.CompositeBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.uiextension.UIExtension;
import org.xwiki.velocity.VelocityManager;

public class WikiUIExtension
implements UIExtension,
WikiComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(WikiUIExtension.class);
    private final DocumentReference documentReference;
    private final DocumentReference authorReference;
    private final String id;
    private final String extensionPointId;
    private String roleHint;
    private XDOM xdom;
    private Syntax syntax;
    private Map<String, String> parameters;
    private WikiComponentScope scope;
    private VelocityManager velocityManager;
    private Transformation macroTransformation;
    private Execution execution;

    public WikiUIExtension(String id, String extensionPointId, ObjectReference objectReference, DocumentReference authorReference, ComponentManager cm) {
        this.documentReference = (DocumentReference)objectReference.getParent();
        this.authorReference = authorReference;
        this.id = id;
        this.extensionPointId = extensionPointId;
        try {
            this.macroTransformation = (Transformation)cm.getInstance(Transformation.class, "macro");
            this.execution = (Execution)cm.getInstance(Execution.class);
            this.velocityManager = (VelocityManager)cm.getInstance(VelocityManager.class);
            EntityReferenceSerializer serializer = (EntityReferenceSerializer)cm.getInstance((Type)EntityReferenceSerializer.TYPE_STRING);
            this.roleHint = (String)serializer.serialize((EntityReference)objectReference, new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error(String.format("Failed to get an instance for a component role required by Wiki Components. Error: [%s]", e.getMessage()));
        }
    }

    public void setXDOM(XDOM xdom) {
        this.xdom = xdom;
    }

    public void setSyntax(Syntax syntax) {
        this.syntax = syntax;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void setScope(WikiComponentScope scope) {
        this.scope = scope;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getExtensionPointId() {
        return this.extensionPointId;
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            StringWriter writer = new StringWriter();
            try {
                this.velocityManager.getVelocityEngine().evaluate((Context)this.velocityManager.getVelocityContext(), (Writer)writer, "", entry.getValue());
                result.put(entry.getKey(), writer.toString());
            }
            catch (Exception e) {
                LOGGER.warn(String.format("Failed to evaluate UI extension data value, key [%s], value [%s]. Reason: [%s]", entry.getKey(), entry.getValue(), e.getMessage()));
            }
        }
        return result;
    }

    @Override
    public Block execute() {
        XDOM transformedXDOM = this.xdom.clone();
        try {
            TransformationContext transformationContext = new TransformationContext(this.xdom, this.syntax);
            transformationContext.setId(this.getRoleHint());
            this.macroTransformation.transform((Block)transformedXDOM, transformationContext);
        }
        catch (Exception e) {
            LOGGER.error("Error while executing wiki component macro transformation for extension [{}]", (Object)this.documentReference.toString());
        }
        return new CompositeBlock(transformedXDOM.getChildren());
    }

    public DocumentReference getDocumentReference() {
        return this.documentReference;
    }

    public DocumentReference getAuthorReference() {
        return this.authorReference;
    }

    public Type getRoleType() {
        return UIExtension.class;
    }

    public String getRoleHint() {
        return this.roleHint;
    }

    public WikiComponentScope getScope() {
        return this.scope;
    }
}

