/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.uiextension.internal.scripting;

import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.script.service.ScriptService;
import org.xwiki.uiextension.UIExtension;
import org.xwiki.uiextension.UIExtensionFilter;
import org.xwiki.uiextension.UIExtensionManager;

@Component
@Named(value="uix")
@Singleton
public class UIExtensionScriptService
implements ScriptService {
    @Inject
    private Logger logger;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> contextComponentManagerProvider;
    @Inject
    private UIExtensionManager uiExtensionManager;

    private String[] parserFilterParameters(String nameList) {
        return nameList.replaceAll(" ", "").split(",");
    }

    public List<UIExtension> getExtensions(String extensionPointId) {
        UIExtensionManager manager;
        try {
            manager = (UIExtensionManager)((ComponentManager)this.contextComponentManagerProvider.get()).getInstance(UIExtensionManager.class, extensionPointId);
        }
        catch (ComponentLookupException e) {
            manager = this.uiExtensionManager;
        }
        return manager.get(extensionPointId);
    }

    public List<UIExtension> getExtensions(String extensionPointId, Map<String, String> filters) {
        List<UIExtension> extensions = this.getExtensions(extensionPointId);
        for (Map.Entry<String, String> entry : filters.entrySet()) {
            String filterHint = entry.getKey();
            try {
                UIExtensionFilter filter = (UIExtensionFilter)((ComponentManager)this.contextComponentManagerProvider.get()).getInstance(UIExtensionFilter.class, filterHint);
                extensions = filter.filter(extensions, this.parserFilterParameters(entry.getValue()));
            }
            catch (ComponentLookupException e) {
                this.logger.warn("Unable to find a UIExtensionFilter for hint [{}] while getting UIExtensions for extension point [{}]", (Object)filterHint, (Object)extensionPointId);
            }
        }
        return extensions;
    }
}

