/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.uiextension.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.classes.BaseClass;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.event.ApplicationReadyEvent;
import org.xwiki.bridge.event.WikiReadyEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.uiextension.internal.WikiUIExtensionConstants;

@Component
@Named(value="wikiUIExtensionComponentBuilderEventListener")
@Singleton
public class WikiUIExtensionComponentBuilderEventListener
implements EventListener,
WikiUIExtensionConstants {
    @Inject
    private Logger logger;
    @Inject
    private Execution execution;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> compactWikiSerializer;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<EntityReference> documentReferenceResolver;

    public List<Event> getEvents() {
        return Arrays.asList(new ApplicationReadyEvent(), new WikiReadyEvent());
    }

    public String getName() {
        return "wikiUIExtensionComponentBuilderEventListener";
    }

    public void onEvent(Event arg0, Object arg1, Object arg2) {
        try {
            this.installOrUpgradeUIExtensionClasses();
        }
        catch (XWikiException e) {
            this.logger.error("Failed to install or update UI Extension XClasses", (Throwable)e);
        }
    }

    private boolean setClassesDocumentFields(XWikiDocument doc, String title) {
        boolean needsUpdate = false;
        if (StringUtils.isBlank((CharSequence)doc.getCreator())) {
            needsUpdate = true;
            doc.setCreator("superadmin");
        }
        if (StringUtils.isBlank((CharSequence)doc.getAuthor())) {
            needsUpdate = true;
            doc.setAuthorReference(doc.getCreatorReference());
        }
        if (StringUtils.isBlank((CharSequence)doc.getParent())) {
            needsUpdate = true;
            doc.setParent("XWiki.XWikiClasses");
        }
        if (StringUtils.isBlank((CharSequence)doc.getTitle())) {
            needsUpdate = true;
            doc.setTitle(title);
        }
        if (StringUtils.isBlank((CharSequence)doc.getContent()) || !Syntax.XWIKI_2_0.equals((Object)doc.getSyntax())) {
            needsUpdate = true;
            doc.setContent("{{include document=\"XWiki.ClassSheet\" /}}");
            doc.setSyntax(Syntax.XWIKI_2_0);
        }
        if (!doc.isHidden().booleanValue()) {
            needsUpdate = true;
            doc.setHidden(Boolean.valueOf(true));
        }
        return needsUpdate;
    }

    public void installOrUpgradeUIExtensionClasses() throws XWikiException {
        XWikiContext xcontext = this.getXWikiContext();
        XWikiDocument doc = xcontext.getWiki().getDocument(this.documentReferenceResolver.resolve((Object)UI_EXTENSION_CLASS, new Object[0]), xcontext);
        BaseClass bclass = doc.getXClass();
        boolean needsUpdate = false;
        needsUpdate |= this.setClassesDocumentFields(doc, "UI Extension Class");
        needsUpdate |= bclass.addTextField("extensionPointId", "Extension Point ID", 30);
        needsUpdate |= bclass.addTextField("name", "Extension ID", 30);
        needsUpdate |= bclass.addTextAreaField("content", "Extension Content", 40, 10);
        needsUpdate |= bclass.addTextAreaField("parameters", "Extension Parameters", 40, 10);
        if (needsUpdate |= bclass.addStaticListField("scope", "Extension Scope", 1, false, "wiki=Current Wiki|user=Current User|global=Global", "select")) {
            if (doc.isNew()) {
                doc.setParent("XWiki.WebHome");
            }
            xcontext.getWiki().saveDocument(doc, xcontext);
        }
    }

    private XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }
}

