/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.uiextension.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.component.wiki.internal.bridge.ContentParser;
import org.xwiki.context.Execution;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.CompositeBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationException;

public class WikiUIExtensionRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(WikiUIExtensionRenderer.class);
    private String roleHint;
    private Transformation macroTransformation;
    private final Execution execution;
    private final XDOM xdom;
    private DocumentReference documentReference;

    public WikiUIExtensionRenderer(String roleHint, String content, DocumentReference documentReference, ComponentManager cm) throws WikiComponentException {
        this.roleHint = roleHint;
        try {
            this.execution = (Execution)cm.getInstance(Execution.class);
            this.macroTransformation = (Transformation)cm.getInstance(Transformation.class, "macro");
            ContentParser contentParser = (ContentParser)cm.getInstance(ContentParser.class);
            XWikiDocument xdoc = this.getXWikiContext().getWiki().getDocument(documentReference, this.getXWikiContext());
            this.xdom = contentParser.parse(content, xdoc.getSyntax());
            this.documentReference = documentReference;
        }
        catch (ComponentLookupException ex) {
            throw new WikiComponentException("Failed to get an instance for a component role required by Wiki Components.", (Throwable)ex);
        }
        catch (Exception e) {
            throw new WikiComponentException(String.format("Failed to retrieve document syntax for document [%s]", documentReference), (Throwable)e);
        }
    }

    public CompositeBlock execute() {
        XDOM transformedXDOM = this.xdom.clone();
        try {
            XWikiDocument xdoc = this.getXWikiContext().getWiki().getDocument(this.documentReference, this.getXWikiContext());
            HashMap<String, Document> uixContext = new HashMap<String, Document>();
            uixContext.put("doc", xdoc.newDocument(this.getXWikiContext()));
            this.getXWikiContext().put((Object)"uix", uixContext);
            TransformationContext transformationContext = new TransformationContext(this.xdom, xdoc.getSyntax());
            transformationContext.setId(this.roleHint);
            this.macroTransformation.transform((Block)transformedXDOM, transformationContext);
        }
        catch (TransformationException e) {
            LOGGER.warn("Error while executing wiki component macro transformation for extension [{}]", (Object)this.roleHint);
        }
        catch (XWikiException ex) {
            LOGGER.warn("Failed to retrieve document [{}]", (Object)this.documentReference);
        }
        return new CompositeBlock(transformedXDOM.getChildren());
    }

    private XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }
}

