/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.uiextension.internal;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import org.xwiki.component.wiki.WikiComponent;
import org.xwiki.component.wiki.WikiComponentScope;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.ObjectReference;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.uiextension.UIExtension;
import org.xwiki.uiextension.internal.WikiUIExtensionParameters;
import org.xwiki.uiextension.internal.WikiUIExtensionRenderer;

public class WikiUIExtension
implements UIExtension,
WikiComponent {
    public static final String CONTEXT_UIX_KEY = "uix";
    public static final String CONTEXT_UIX_DOC_KEY = "doc";
    private final DocumentReference documentReference;
    private final DocumentReference authorReference;
    private final String id;
    private final String extensionPointId;
    private final String roleHint;
    private WikiUIExtensionParameters parameters;
    private WikiUIExtensionRenderer renderer;
    private WikiComponentScope scope = WikiComponentScope.WIKI;

    public WikiUIExtension(String roleHint, String id, String extensionPointId, ObjectReference objectReference, DocumentReference authorReference) {
        this.roleHint = roleHint;
        this.id = id;
        this.extensionPointId = extensionPointId;
        this.authorReference = authorReference;
        this.documentReference = (DocumentReference)objectReference.getParent();
    }

    public void setParameters(WikiUIExtensionParameters parameters) {
        this.parameters = parameters;
    }

    public void setRenderer(WikiUIExtensionRenderer renderer) {
        this.renderer = renderer;
    }

    public void setScope(WikiComponentScope scope) {
        this.scope = scope;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getExtensionPointId() {
        return this.extensionPointId;
    }

    @Override
    public Map<String, String> getParameters() {
        if (this.parameters != null) {
            return this.parameters.get();
        }
        return Collections.emptyMap();
    }

    @Override
    public Block execute() {
        if (this.renderer != null) {
            return this.renderer.execute();
        }
        return new WordBlock("");
    }

    public DocumentReference getDocumentReference() {
        return this.documentReference;
    }

    public DocumentReference getAuthorReference() {
        return this.authorReference;
    }

    public Type getRoleType() {
        return UIExtension.class;
    }

    public String getRoleHint() {
        return this.roleHint;
    }

    public WikiComponentScope getScope() {
        return this.scope;
    }
}

