/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal;

import java.lang.reflect.Type;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.resource.CreateResourceReferenceException;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceResolver;
import org.xwiki.resource.ResourceType;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.URLConfiguration;

@Component
@Singleton
public class DefaultResourceReferenceResolver
implements ResourceReferenceResolver<ExtendedURL> {
    @Inject
    private URLConfiguration configuration;
    @Inject
    @Named(value="generic")
    private ResourceReferenceResolver<ExtendedURL> genericResourceReferenceResolver;
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;

    public ResourceReference resolve(ExtendedURL extendedURL, ResourceType type, Map<String, Object> parameters) throws CreateResourceReferenceException, UnsupportedResourceReferenceException {
        ResourceReferenceResolver resolver;
        DefaultParameterizedType parameterizedType = new DefaultParameterizedType(null, ResourceReferenceResolver.class, new Type[]{ExtendedURL.class});
        String hint = this.configuration.getURLFormatId();
        if (this.componentManager.hasComponent((Type)parameterizedType, hint)) {
            try {
                resolver = (ResourceReferenceResolver)this.componentManager.getInstance((Type)parameterizedType, hint);
            }
            catch (ComponentLookupException e) {
                throw new CreateResourceReferenceException(String.format("Failed to create Resource Reference for [%s].", extendedURL.getWrappedURL()), (Throwable)e);
            }
        } else {
            resolver = this.genericResourceReferenceResolver;
        }
        return resolver.resolve((Object)extendedURL, type, parameters);
    }
}

