/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.xwiki.resource.CreateResourceReferenceException;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceType;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.internal.AbstractResourceReferenceResolver;
import org.xwiki.url.internal.ParentResourceReference;

public abstract class AbstractParentResourceReferenceResolver
extends AbstractResourceReferenceResolver {
    public ParentResourceReference resolve(ExtendedURL extendedURL, ResourceType resourceType, Map<String, Object> parameters) throws CreateResourceReferenceException, UnsupportedResourceReferenceException {
        String path = "";
        String child = "";
        List<String> pathSegments = extendedURL.getSegments();
        if (!pathSegments.isEmpty()) {
            StringBuilder pathBuilder = new StringBuilder();
            try {
                for (String pathSegment : extendedURL.getSegments()) {
                    if (pathBuilder.length() > 0) {
                        pathBuilder.append('/');
                    }
                    pathBuilder.append(URLEncoder.encode(pathSegment, "UTF8"));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            path = pathBuilder.toString();
            child = pathSegments.get(0);
            pathSegments = pathSegments.size() > 1 ? pathSegments.subList(1, pathSegments.size()) : Collections.emptyList();
        }
        ParentResourceReference reference = new ParentResourceReference(resourceType, path, child, pathSegments);
        this.copyParameters(extendedURL, (ResourceReference)reference);
        return reference;
    }
}

