/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal;

import java.lang.reflect.Type;
import java.net.URL;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.url.URLConfiguration;
import org.xwiki.url.URLCreationException;
import org.xwiki.url.UnsupportedURLException;
import org.xwiki.url.XWikiURL;
import org.xwiki.url.XWikiURLFactory;

@Component
@Singleton
public class DefaultXWikiURLFactory
implements XWikiURLFactory<URL, XWikiURL> {
    @Inject
    private URLConfiguration configuration;
    @Inject
    private ComponentManager componentManager;

    @Override
    public XWikiURL createURL(URL urlRepresentation, Map<String, Object> parameters) throws URLCreationException, UnsupportedURLException {
        XWikiURLFactory factory;
        try {
            factory = (XWikiURLFactory)this.componentManager.getInstance((Type)XWikiURLFactory.TYPE_URL_XWIKIURL, this.configuration.getURLFormatId());
        }
        catch (ComponentLookupException e) {
            throw new URLCreationException(String.format("Invalid configuration hint [%s]. Cannot create XWiki URL.", this.configuration.getURLFormatId()), e);
        }
        return factory.createURL(urlRepresentation, parameters);
    }
}

