/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal;

import java.lang.reflect.Type;
import java.net.URL;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.resource.Resource;
import org.xwiki.resource.ResourceCreationException;
import org.xwiki.resource.ResourceFactory;
import org.xwiki.resource.UnsupportedResourceException;
import org.xwiki.url.URLConfiguration;

@Component
@Singleton
public class DefaultResourceFactory
implements ResourceFactory<URL, Resource> {
    @Inject
    private URLConfiguration configuration;
    @Inject
    private ComponentManager componentManager;

    public Resource createResource(URL urlRepresentation, Map<String, Object> parameters) throws ResourceCreationException, UnsupportedResourceException {
        ResourceFactory factory;
        try {
            factory = (ResourceFactory)this.componentManager.getInstance((Type)ResourceFactory.TYPE_URL_RESOURCE, this.configuration.getURLFormatId());
        }
        catch (ComponentLookupException e) {
            throw new ResourceCreationException(String.format("Invalid configuration hint [%s]. Cannot create Resource for [%s].", this.configuration.getURLFormatId(), urlRepresentation), (Throwable)e);
        }
        return factory.createResource((Object)urlRepresentation, parameters);
    }
}

