/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal;

import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceSerializer;
import org.xwiki.resource.SerializeResourceReferenceException;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.URLContextManager;

@Component
@Singleton
public class DefaultResourceReferenceSerializer
implements ResourceReferenceSerializer<ResourceReference, ExtendedURL> {
    @Inject
    private URLContextManager urlContextManager;
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;

    public ExtendedURL serialize(ResourceReference resource) throws SerializeResourceReferenceException, UnsupportedResourceReferenceException {
        ResourceReferenceSerializer serializer;
        DefaultParameterizedType type = new DefaultParameterizedType(null, ResourceReferenceSerializer.class, new Type[]{ResourceReference.class, ExtendedURL.class});
        try {
            serializer = (ResourceReferenceSerializer)this.componentManager.getInstance((Type)type, this.urlContextManager.getURLFormatId());
        }
        catch (ComponentLookupException e) {
            throw new UnsupportedResourceReferenceException(String.format("Invalid URL format id [%s]. Cannot serialize Resource Reference [%s].", this.urlContextManager.getURLFormatId(), resource), (Throwable)e);
        }
        return (ExtendedURL)serializer.serialize(resource);
    }
}

