/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal;

import java.lang.reflect.Type;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.resource.CreateResourceTypeException;
import org.xwiki.resource.ResourceType;
import org.xwiki.resource.ResourceTypeResolver;
import org.xwiki.url.URLConfiguration;

@Component
@Singleton
public class DefaultStringResourceTypeResolver
implements ResourceTypeResolver<String> {
    @Inject
    private URLConfiguration configuration;
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;
    @Inject
    @Named(value="generic")
    private ResourceTypeResolver<String> genericResourceTypeResolver;

    public ResourceType resolve(String type, Map<String, Object> parameters) throws CreateResourceTypeException {
        ResourceTypeResolver resolver;
        DefaultParameterizedType parameterizedType = new DefaultParameterizedType(null, ResourceTypeResolver.class, new Type[]{String.class});
        String hint = this.configuration.getURLFormatId();
        if (this.componentManager.hasComponent((Type)parameterizedType, hint)) {
            try {
                resolver = (ResourceTypeResolver)this.componentManager.getInstance((Type)parameterizedType, hint);
            }
            catch (ComponentLookupException e) {
                throw new CreateResourceTypeException(String.format("Failed to convert Resource Type from String [%s] to [%s]", type, ResourceType.class.getSimpleName()), (Throwable)e);
            }
        } else {
            resolver = this.genericResourceTypeResolver;
        }
        return resolver.resolve((Object)type, parameters);
    }
}

