/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal;

import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceSerializer;
import org.xwiki.resource.SerializeResourceReferenceException;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.url.ExtendedURL;

public abstract class AbstractExtendedURLResourceReferenceSerializer
implements ResourceReferenceSerializer<ResourceReference, ExtendedURL> {
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;

    public ExtendedURL serialize(ResourceReference reference, String formatId) throws SerializeResourceReferenceException, UnsupportedResourceReferenceException {
        ResourceReferenceSerializer serializer;
        try {
            serializer = (ResourceReferenceSerializer)this.componentManager.getInstance((Type)new DefaultParameterizedType(null, ResourceReferenceSerializer.class, new Type[]{reference.getClass(), ExtendedURL.class}), formatId);
        }
        catch (ComponentLookupException e) {
            try {
                serializer = (ResourceReferenceSerializer)this.componentManager.getInstance((Type)new DefaultParameterizedType(null, ResourceReferenceSerializer.class, new Type[]{reference.getClass(), ExtendedURL.class}));
            }
            catch (ComponentLookupException cle) {
                throw new UnsupportedResourceReferenceException(String.format("Failed to find serializer for Resource Reference [%s] and URL format [%s]", reference, formatId), (Throwable)cle);
            }
        }
        return (ExtendedURL)serializer.serialize(reference);
    }
}

