/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal;

import java.lang.reflect.Type;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.resource.CreateResourceTypeException;
import org.xwiki.resource.ResourceType;
import org.xwiki.resource.ResourceTypeResolver;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.URLConfiguration;

@Component
@Singleton
public class DefaultResourceTypeResolver
implements ResourceTypeResolver<ExtendedURL> {
    @Inject
    private URLConfiguration configuration;
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;

    public ResourceType resolve(ExtendedURL extendedURL, Map<String, Object> parameters) throws CreateResourceTypeException {
        ResourceTypeResolver resolver;
        try {
            resolver = (ResourceTypeResolver)this.componentManager.getInstance((Type)new DefaultParameterizedType(null, ResourceTypeResolver.class, new Type[]{ExtendedURL.class}), this.configuration.getURLFormatId());
        }
        catch (ComponentLookupException e) {
            throw new CreateResourceTypeException(String.format("Invalid configuration hint [%s]. Cannot create Resource Type for [%s].", this.configuration.getURLFormatId(), extendedURL.getWrappedURL()), (Throwable)e);
        }
        return resolver.resolve((Object)extendedURL, parameters);
    }
}

