/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.container.Container;
import org.xwiki.container.servlet.ServletRequest;
import org.xwiki.environment.Environment;
import org.xwiki.environment.internal.ServletEnvironment;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.URLNormalizer;

@Component
@Named(value="contextpath+actionservletpath")
@Singleton
public class ContextAndActionURLNormalizer
implements URLNormalizer<ExtendedURL>,
Initializable {
    private static final String URL_SEGMENT_DELIMITER = "/";
    private static final String IGNORED_MAPPING_CHARACTERS = "/*";
    @Inject
    private Container container;
    @Inject
    private Environment environment;
    private String defaultServletMapping = "bin";
    private Collection<String> validServletMappings = new LinkedHashSet<String>();

    public void initialize() {
        if (this.environment instanceof ServletEnvironment) {
            for (String mapping : ((ServletEnvironment)this.environment).getServletContext().getServletRegistration("action").getMappings()) {
                this.validServletMappings.add(StringUtils.strip((String)mapping, (String)IGNORED_MAPPING_CHARACTERS));
            }
        }
        if (!this.validServletMappings.isEmpty()) {
            this.defaultServletMapping = this.validServletMappings.iterator().next();
        }
    }

    public ExtendedURL normalize(ExtendedURL partialURL) {
        String servletPath;
        String contextPath = StringUtils.strip((String)this.getContextPath(), (String)URL_SEGMENT_DELIMITER);
        if (contextPath == null) {
            throw new RuntimeException(String.format("Failed to normalize the URL [%s] since the application's Servlet context couldn't be computed.", partialURL));
        }
        ArrayList<String> segments = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)contextPath)) {
            segments.add(contextPath);
        }
        if (StringUtils.isNotEmpty((CharSequence)(servletPath = this.getActionServletMapping()))) {
            segments.add(servletPath);
        }
        segments.addAll(partialURL.getSegments());
        return new ExtendedURL(segments, partialURL.getParameters());
    }

    protected String getContextPath() {
        if (this.environment instanceof ServletEnvironment) {
            return ((ServletEnvironment)this.environment).getServletContext().getContextPath();
        }
        return null;
    }

    protected String getActionServletMapping() {
        HttpServletRequest hsRequest;
        String result = this.defaultServletMapping;
        if (this.container.getRequest() instanceof ServletRequest && !this.validServletMappings.contains(result = StringUtils.strip((String)(hsRequest = ((ServletRequest)this.container.getRequest()).getHttpServletRequest()).getServletPath(), (String)IGNORED_MAPPING_CHARACTERS))) {
            result = this.defaultServletMapping;
        }
        return result;
    }
}

