/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal.standard;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.url.XWikiEntityURL;
import org.xwiki.url.XWikiURL;
import org.xwiki.url.standard.XWikiURLBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="entity")
public class EntityXWikiURLBuilder
implements XWikiURLBuilder {
    @Requirement(value="default/reference")
    private EntityReferenceResolver<EntityReference> defaultReferenceEntityReferenceResolver;

    @Override
    public XWikiURL build(WikiReference wikiReference, List<String> pathSegments) {
        String spaceName = null;
        String pageName = null;
        String attachmentName = null;
        String action = "view";
        if (pathSegments.size() == 1) {
            pageName = pathSegments.get(0);
        } else if (pathSegments.size() == 2) {
            spaceName = pathSegments.get(0);
            pageName = pathSegments.get(1);
        } else if (pathSegments.size() >= 3) {
            action = pathSegments.get(0);
            spaceName = pathSegments.get(1);
            pageName = pathSegments.get(2);
            if (action.equals("download") && pathSegments.size() >= 4) {
                attachmentName = pathSegments.get(3);
            }
        }
        WikiReference reference = wikiReference;
        EntityType entityType = EntityType.DOCUMENT;
        if (!StringUtils.isEmpty((String)spaceName)) {
            reference = new EntityReference(spaceName, EntityType.SPACE, (EntityReference)reference);
        }
        if (!StringUtils.isEmpty((String)pageName)) {
            reference = new EntityReference(pageName, EntityType.DOCUMENT, (EntityReference)reference);
        }
        if (!StringUtils.isEmpty(attachmentName)) {
            reference = new EntityReference(attachmentName, EntityType.ATTACHMENT, (EntityReference)reference);
            entityType = EntityType.ATTACHMENT;
        }
        reference = this.defaultReferenceEntityReferenceResolver.resolve((Object)reference, entityType, new Object[0]);
        XWikiEntityURL entityURL = new XWikiEntityURL((EntityReference)reference);
        entityURL.setAction(action);
        return entityURL;
    }
}

