/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal.standard;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.url.InvalidURLException;
import org.xwiki.url.XWikiURL;
import org.xwiki.url.XWikiURLFactory;
import org.xwiki.url.XWikiURLType;
import org.xwiki.url.standard.HostResolver;
import org.xwiki.url.standard.StandardURLConfiguration;
import org.xwiki.url.standard.XWikiURLBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="standard")
public class StandardXWikiURLFactory
implements XWikiURLFactory<URL> {
    private static final String IGNORE_PREFIX_KEY = "ignorePrefix";
    @Requirement
    private StandardURLConfiguration configuration;
    @Requirement(value="path")
    private HostResolver pathBasedHostResolver;
    @Requirement(value="domain")
    private HostResolver domainHostResolver;
    @Requirement
    private ComponentManager componentManager;

    public XWikiURL createURL(URL url, Map<String, Object> parameters) throws InvalidURLException {
        XWikiURLBuilder builder;
        URI uri;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            throw new InvalidURLException("Invalid URL [" + url + "]", (Throwable)e);
        }
        String ignorePrefix = (String)parameters.get(IGNORE_PREFIX_KEY);
        if (ignorePrefix != null && !uri.getPath().startsWith(ignorePrefix)) {
            throw new InvalidURLException("URL Path doesn't start with [" + ignorePrefix + "]");
        }
        String path = uri.getRawPath().substring(ignorePrefix.length() + 1);
        URLParsingState state = new URLParsingState();
        state.urlSegments = this.extractPathSegments(path);
        WikiReference wikiReference = this.extractWikiReference(uri, state);
        if (state.urlType == null) {
            String typeAsString = state.urlSegments.remove(0);
            state.urlType = this.getXWikiURLType(typeAsString);
        }
        try {
            builder = (XWikiURLBuilder)this.componentManager.lookup(XWikiURLBuilder.class, state.urlType.toString().toLowerCase());
        }
        catch (ComponentLookupException e) {
            throw new InvalidURLException("URL type [" + state.urlType + "] not supported yet!");
        }
        XWikiURL xwikiURL = builder.build(wikiReference, state.urlSegments);
        if (uri.getQuery() != null) {
            for (String nameValue : Arrays.asList(uri.getQuery().split("&"))) {
                String[] pair = nameValue.split("=", 2);
                if (pair.length == 2) {
                    xwikiURL.addParameter(pair[0], pair[1]);
                    continue;
                }
                xwikiURL.addParameter(pair[0], null);
            }
        }
        return xwikiURL;
    }

    protected List<String> extractPathSegments(String rawPath) {
        ArrayList<String> urlSegments = new ArrayList<String>();
        for (String pathSegment : rawPath.split("/", -1)) {
            String decodedPathSegment;
            String normalizedPathSegment = pathSegment.split(";", 2)[0];
            try {
                decodedPathSegment = URLDecoder.decode(normalizedPathSegment, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Failed to URL decode [" + normalizedPathSegment + "] using UTF-8.", e);
            }
            urlSegments.add(decodedPathSegment);
        }
        return urlSegments;
    }

    protected WikiReference extractWikiReference(URI uri, URLParsingState state) {
        WikiReference wikiReference = null;
        if (this.configuration.isPathBasedMultiWiki() && state.urlSegments.get(0).equalsIgnoreCase(this.configuration.getWikiPathPrefix())) {
            wikiReference = this.pathBasedHostResolver.resolve(state.urlSegments.get(1));
            state.urlSegments.remove(0);
            state.urlSegments.remove(0);
            state.urlType = XWikiURLType.ENTITY;
        }
        if (wikiReference == null) {
            wikiReference = this.domainHostResolver.resolve(uri.getHost());
        }
        return wikiReference;
    }

    protected XWikiURLType getXWikiURLType(String type) throws InvalidURLException {
        if (!type.equalsIgnoreCase("bin")) {
            throw new InvalidURLException("Invalid URL type [" + type + "]");
        }
        XWikiURLType result = XWikiURLType.ENTITY;
        return result;
    }

    private class URLParsingState {
        public List<String> urlSegments;
        public XWikiURLType urlType;

        private URLParsingState() {
        }
    }
}

