/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal.standard;

import javax.inject.Inject;
import org.xwiki.context.Execution;
import org.xwiki.url.internal.standard.StandardURLConfiguration;
import org.xwiki.url.internal.standard.WikiNotFoundBehavior;
import org.xwiki.url.internal.standard.WikiReferenceExtractor;
import org.xwiki.wiki.descriptor.WikiDescriptor;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

public abstract class AbstractWikiReferenceExtractor
implements WikiReferenceExtractor {
    @Inject
    private StandardURLConfiguration configuration;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private Execution execution;

    protected String normalizeWikiIdForNonExistentWikiDescriptor(String alias) {
        String normalizedWikiId = alias;
        String mainWiki = this.getMainWikiId();
        if (!mainWiki.equals(normalizedWikiId) && this.configuration.getWikiNotFoundBehavior() == WikiNotFoundBehavior.REDIRECT_TO_MAIN_WIKI && this.getWikiDescriptorById(normalizedWikiId) == null) {
            normalizedWikiId = mainWiki;
        }
        return normalizedWikiId;
    }

    protected WikiDescriptor getWikiDescriptorByAlias(String alias) {
        if (this.execution.getContext() == null) {
            return null;
        }
        try {
            return this.wikiDescriptorManager.getByAlias(alias);
        }
        catch (WikiManagerException e) {
            throw new RuntimeException(String.format("Failed to locate wiki descriptor for alias [%s]", alias), e);
        }
    }

    protected WikiDescriptor getWikiDescriptorById(String wikiId) {
        if (this.execution.getContext() == null) {
            return null;
        }
        try {
            return this.wikiDescriptorManager.getById(wikiId);
        }
        catch (WikiManagerException e) {
            throw new RuntimeException(String.format("Failed to locate wiki descriptor for wiki [%s]", wikiId), e);
        }
    }

    protected String getMainWikiId() {
        return this.wikiDescriptorManager.getMainWikiId();
    }
}

