/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal.standard;

import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.internal.standard.AbstractWikiReferenceExtractor;
import org.xwiki.wiki.descriptor.WikiDescriptor;

@Component
@Named(value="path")
@Singleton
public class PathWikiReferenceExtractor
extends AbstractWikiReferenceExtractor {
    @Override
    public WikiReference extract(ExtendedURL url) {
        String wikiId = this.resolvePathBasedWikiReference((String)url.getSegments().get(0));
        if (StringUtils.isEmpty((CharSequence)wikiId)) {
            wikiId = this.getMainWikiId();
        }
        return new WikiReference(wikiId.toLowerCase());
    }

    private String resolvePathBasedWikiReference(String alias) {
        WikiDescriptor wikiDescriptor = this.getWikiDescriptorByAlias(alias);
        String wikiId = wikiDescriptor != null ? wikiDescriptor.getId() : this.normalizeWikiIdForNonExistentWikiDescriptor(alias);
        return wikiId;
    }
}

