/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal.standard;

import java.lang.reflect.Type;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.descriptor.ComponentDependency;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.descriptor.DefaultComponentDependency;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.manager.ComponentRepositoryException;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.resource.CreateResourceTypeException;
import org.xwiki.resource.ResourceReferenceResolver;
import org.xwiki.resource.ResourceType;
import org.xwiki.resource.entity.EntityResourceReference;
import org.xwiki.resource.internal.entity.EntityResourceActionLister;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.internal.AbstractExtendedURLResourceTypeResolver;
import org.xwiki.url.internal.standard.StandardURLConfiguration;
import org.xwiki.url.internal.standard.WikiReferenceExtractor;
import org.xwiki.url.internal.standard.entity.BinEntityResourceReferenceResolver;
import org.xwiki.url.internal.standard.entity.WikiEntityResourceReferenceResolver;

@Component
@Named(value="standard")
@Singleton
public class StandardExtendedURLResourceTypeResolver
extends AbstractExtendedURLResourceTypeResolver
implements Initializable {
    private static final String HINT = "standard";
    @Inject
    private ComponentManager rootComponentManager;
    @Inject
    private StandardURLConfiguration configuration;

    public void initialize() throws InitializationException {
        this.registerEntityResourceReferenceResolver(this.configuration.getWikiPathPrefix(), WikiEntityResourceReferenceResolver.class, "path");
        this.registerEntityResourceReferenceResolver(EntityResourceReference.TYPE.getId(), BinEntityResourceReferenceResolver.class, "domain");
    }

    public ResourceType resolve(ExtendedURL extendedURL, Map<String, Object> parameters) throws CreateResourceTypeException {
        return this.resolve(HINT, extendedURL, parameters);
    }

    private void registerEntityResourceReferenceResolver(String registrationHint, Class<? extends ResourceReferenceResolver<ExtendedURL>> registrationImplementation, String wikiExtractorHint) throws InitializationException {
        DefaultComponentDescriptor resolverDescriptor = new DefaultComponentDescriptor();
        resolverDescriptor.setImplementation(registrationImplementation);
        resolverDescriptor.setInstantiationStrategy(ComponentInstantiationStrategy.SINGLETON);
        String hint = this.computeHint(registrationHint);
        resolverDescriptor.setRoleHint(hint);
        resolverDescriptor.setRoleType((Type)new DefaultParameterizedType(null, ResourceReferenceResolver.class, new Type[]{ExtendedURL.class}));
        DefaultComponentDependency wikiReferenceExtractorDependency = new DefaultComponentDependency();
        wikiReferenceExtractorDependency.setRoleType(WikiReferenceExtractor.class);
        wikiReferenceExtractorDependency.setRoleHint(wikiExtractorHint);
        wikiReferenceExtractorDependency.setName("wikiExtractor");
        resolverDescriptor.addComponentDependency((ComponentDependency)wikiReferenceExtractorDependency);
        DefaultComponentDependency entityReferenceResolverDependency = new DefaultComponentDependency();
        entityReferenceResolverDependency.setRoleType((Type)new DefaultParameterizedType(null, EntityReferenceResolver.class, new Type[]{EntityReference.class}));
        entityReferenceResolverDependency.setName("defaultReferenceEntityReferenceResolver");
        resolverDescriptor.addComponentDependency((ComponentDependency)entityReferenceResolverDependency);
        DefaultComponentDependency standardURLConfigurationDependency = new DefaultComponentDependency();
        standardURLConfigurationDependency.setRoleType(StandardURLConfiguration.class);
        standardURLConfigurationDependency.setName("configuration");
        resolverDescriptor.addComponentDependency((ComponentDependency)standardURLConfigurationDependency);
        DefaultComponentDependency entityResourceActionListerDependency = new DefaultComponentDependency();
        entityResourceActionListerDependency.setRoleType(EntityResourceActionLister.class);
        entityResourceActionListerDependency.setName("entityResourceActionLister");
        resolverDescriptor.addComponentDependency((ComponentDependency)entityResourceActionListerDependency);
        try {
            this.rootComponentManager.registerComponent((ComponentDescriptor)resolverDescriptor);
        }
        catch (ComponentRepositoryException e) {
            throw new InitializationException(String.format("Failed to dynamically register Resource Reference Resolver for hint [%s]", hint), (Throwable)e);
        }
    }

    private String computeHint(String type) {
        return String.format("%s/%s", HINT, type);
    }
}

