/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal.standard;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.url.internal.standard.StandardURLConfiguration;
import org.xwiki.url.internal.standard.WikiNotFoundBehavior;

@Component
@Singleton
public class DefaultStandardURLConfiguration
implements StandardURLConfiguration {
    private static final String PREFIX = "url.standard.";
    @Inject
    @Named(value="xwikiproperties")
    private ConfigurationSource configuration;

    @Override
    public boolean isPathBasedMultiWiki() {
        return this.isPathBasedMultiWiki(Boolean.TRUE);
    }

    protected boolean isPathBasedMultiWiki(Boolean defaultValue) {
        return (Boolean)this.configuration.getProperty("url.standard.multiwiki.isPathBased", (Object)defaultValue);
    }

    @Override
    public String getWikiPathPrefix() {
        return this.getWikiPathPrefix("wiki");
    }

    @Override
    public WikiNotFoundBehavior getWikiNotFoundBehavior() {
        return this.getWikiNotFoundBehavior(WikiNotFoundBehavior.REDIRECT_TO_MAIN_WIKI);
    }

    @Override
    public String getEntityPathPrefix() {
        return this.getEntityPathPrefix("bin");
    }

    @Override
    public boolean isViewActionHidden() {
        return this.isViewActionHidden(false);
    }

    protected String getWikiPathPrefix(String defaultValue) {
        return (String)this.configuration.getProperty("url.standard.multiwiki.wikiPathPrefix", (Object)defaultValue);
    }

    protected boolean isViewActionHidden(boolean defaultValue) {
        return (Boolean)this.configuration.getProperty("url.standard.hideViewAction", (Object)defaultValue);
    }

    protected String getEntityPathPrefix(String defaultValue) {
        return (String)this.configuration.getProperty("url.standard.entityPathPrefix", (Object)defaultValue);
    }

    protected WikiNotFoundBehavior getWikiNotFoundBehavior(WikiNotFoundBehavior defaultValue) {
        return (WikiNotFoundBehavior)((Object)this.configuration.getProperty("url.standard.multiwiki.notFoundBehavior", (Object)defaultValue));
    }
}

