/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal.standard.temporary;

import java.util.HashMap;
import java.util.LinkedList;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.resource.ResourceReferenceSerializer;
import org.xwiki.resource.SerializeResourceReferenceException;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.resource.temporary.TemporaryResourceReference;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.URLNormalizer;

@Component
@Named(value="standard/tmp")
@Singleton
public class ExtendedURLTemporaryResourceReferenceSerializer
implements ResourceReferenceSerializer<TemporaryResourceReference, ExtendedURL> {
    @Inject
    @Named(value="contextpath+actionservletpath")
    private URLNormalizer<ExtendedURL> extendedURLNormalizer;

    public ExtendedURL serialize(TemporaryResourceReference resource) throws SerializeResourceReferenceException, UnsupportedResourceReferenceException {
        DocumentReference owningReference = (DocumentReference)resource.getOwningEntityReference();
        LinkedList<String> segments = new LinkedList<String>();
        segments.add("temp");
        segments.add(owningReference.getLastSpaceReference().getName());
        segments.add(owningReference.getName());
        segments.add(resource.getModuleId());
        segments.add(resource.getResourceName());
        ExtendedURL result = new ExtendedURL(segments, new HashMap());
        return (ExtendedURL)this.extendedURLNormalizer.normalize(result);
    }
}

