/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal.standard;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.url.internal.ExtendedURL;
import org.xwiki.url.internal.standard.StandardURLConfiguration;
import org.xwiki.url.internal.standard.WikiReferenceExtractor;
import org.xwiki.url.internal.standard.WikiReferenceResolver;

@Component
@Singleton
public class DefaultWikiReferenceExtractor
implements WikiReferenceExtractor {
    @Inject
    @Named(value="path")
    private WikiReferenceResolver pathBasedWikiReferenceResolver;
    @Inject
    @Named(value="domain")
    private WikiReferenceResolver domainWikiReferenceResolver;
    @Inject
    private StandardURLConfiguration configuration;

    @Override
    public Pair<WikiReference, Boolean> extract(ExtendedURL url) {
        List segments;
        boolean isActuallyPathBased = false;
        WikiReference wikiReference = null;
        if (this.configuration.isPathBasedMultiWiki() && ((String)(segments = url.getSegments()).get(0)).equalsIgnoreCase(this.configuration.getWikiPathPrefix())) {
            wikiReference = this.pathBasedWikiReferenceResolver.resolve((String)segments.get(1));
            isActuallyPathBased = true;
        }
        if (wikiReference == null) {
            wikiReference = this.domainWikiReferenceResolver.resolve(url.getURI().getHost());
        }
        return new ImmutablePair(wikiReference, (Object)isActuallyPathBased);
    }
}

