/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal.standard;

import java.net.URL;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.url.URLCreationException;
import org.xwiki.url.UnsupportedURLException;
import org.xwiki.url.XWikiEntityURL;
import org.xwiki.url.XWikiURL;
import org.xwiki.url.XWikiURLFactory;
import org.xwiki.url.internal.ExtendedURL;
import org.xwiki.url.internal.standard.StandardURLConfiguration;

@Component
@Named(value="standard")
@Singleton
public class StandardXWikiURLFactory
implements XWikiURLFactory<URL, XWikiURL> {
    private static final String IGNORE_PREFIX_KEY = "ignorePrefix";
    @Inject
    @Named(value="standard")
    private XWikiURLFactory<ExtendedURL, XWikiEntityURL> entityURLFactory;
    @Inject
    private StandardURLConfiguration configuration;

    public XWikiURL createURL(URL url, Map<String, Object> parameters) throws URLCreationException, UnsupportedURLException {
        String ignorePrefix = (String)parameters.get(IGNORE_PREFIX_KEY);
        ExtendedURL extendedURL = new ExtendedURL(url, ignorePrefix);
        String type = (String)extendedURL.getSegments().get(0);
        if (!type.equals("bin") && !type.equals(this.configuration.getWikiPathPrefix())) {
            throw new UnsupportedURLException(String.format("URL type [%s] are not yet supported!", type));
        }
        XWikiURL xwikiURL = this.entityURLFactory.createURL((Object)extendedURL, parameters);
        return xwikiURL;
    }
}

