/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal.standard.entity;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.resource.CreateResourceReferenceException;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceResolver;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.resource.entity.EntityResourceAction;
import org.xwiki.resource.entity.EntityResourceReference;
import org.xwiki.url.ExtendedURL;

public abstract class AbstractEntityResourceReferenceResolver
implements ResourceReferenceResolver<ExtendedURL> {
    private EntityReferenceResolver<EntityReference> defaultReferenceEntityReferenceResolver;

    protected abstract WikiReference extractWikiReference(ExtendedURL var1);

    public ResourceReference resolve(ExtendedURL url, Map<String, Object> parameters) throws CreateResourceReferenceException, UnsupportedResourceReferenceException {
        WikiReference wikiReference = this.extractWikiReference(url);
        List pathSegments = url.getSegments();
        String spaceName = null;
        String pageName = null;
        String attachmentName = null;
        String action = "view";
        if (pathSegments.size() == 1) {
            pageName = (String)pathSegments.get(0);
        } else if (pathSegments.size() == 2) {
            spaceName = (String)pathSegments.get(0);
            pageName = (String)pathSegments.get(1);
        } else if (pathSegments.size() >= 3) {
            action = (String)pathSegments.get(0);
            spaceName = (String)pathSegments.get(1);
            pageName = (String)pathSegments.get(2);
            if (action.equals("download") && pathSegments.size() >= 4) {
                attachmentName = (String)pathSegments.get(3);
            }
        }
        EntityResourceReference entityURL = new EntityResourceReference(this.buildEntityReference(wikiReference, spaceName, pageName, attachmentName), EntityResourceAction.fromString((String)action));
        this.copyParameters(url, entityURL);
        return entityURL;
    }

    private EntityReference buildEntityReference(WikiReference wikiReference, String spaceName, String pageName, String attachmentName) {
        WikiReference reference = wikiReference;
        EntityType entityType = EntityType.DOCUMENT;
        if (!StringUtils.isEmpty((CharSequence)spaceName)) {
            reference = new EntityReference(spaceName, EntityType.SPACE, (EntityReference)reference);
        }
        if (!StringUtils.isEmpty((CharSequence)pageName)) {
            reference = new EntityReference(pageName, EntityType.DOCUMENT, (EntityReference)reference);
        }
        if (!StringUtils.isEmpty((CharSequence)attachmentName)) {
            reference = new EntityReference(attachmentName, EntityType.ATTACHMENT, (EntityReference)reference);
            entityType = EntityType.ATTACHMENT;
        }
        return this.defaultReferenceEntityReferenceResolver.resolve((Object)reference, entityType, new Object[0]);
    }

    private void copyParameters(ExtendedURL source, EntityResourceReference target) {
        if (source.getURI().getQuery() != null) {
            for (String nameValue : Arrays.asList(source.getURI().getQuery().split("&"))) {
                String[] pair = nameValue.split("=", 2);
                if (pair.length == 2) {
                    target.addParameter(pair[0], pair[1]);
                    continue;
                }
                target.addParameter(pair[0], null);
            }
        }
    }
}

