/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal.standard.temporary;

import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.resource.ResourceReferenceSerializer;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.resource.temporary.TemporaryResourceReference;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.URLNormalizer;

@Component
@Named(value="standard/tmp")
@Singleton
public class ExtendedURLTemporaryResourceReferenceSerializer
implements ResourceReferenceSerializer<TemporaryResourceReference, ExtendedURL> {
    @Inject
    private URLNormalizer<ExtendedURL> normalizer;

    public ExtendedURL serialize(TemporaryResourceReference resource) throws UnsupportedResourceReferenceException {
        DocumentReference owningReference = (DocumentReference)resource.getOwningEntityReference();
        return new ExtendedURL(Arrays.asList(owningReference.getLastSpaceReference().getName(), owningReference.getName(), resource.getModuleId(), resource.getResourceName()));
    }
}

