/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.user;

import org.xwiki.component.annotation.Role;
import org.xwiki.stability.Unstable;

/**
 * Gets the properties for a user (represented by a {@link UserReference}).
 *
 * @version $Id: f7c92e76f32b26cb8280984de9f867fd359ac035 $
 * @since 12.2
 */
@Unstable
@Role
// Note: the reason why we didn't have UserPropertiesResolver<? extends UserReference> is to make the API easier to use
// and make less mistakes since only UserReference should be used (and not DocumentUserReference for example).
public interface UserPropertiesResolver
{
    /**
     * @param userReference the reference to the user
     * @param parameters optional parameters that have a meaning only for the specific resolver implementation used
     * @return the resolved user properties (direct or inherited depending on the implementation)
     */
    UserProperties resolve(UserReference userReference, Object... parameters);
}
