/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.user.internal;

import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.user.CurrentUserReference;
import org.xwiki.user.GuestUserReference;
import org.xwiki.user.SuperAdminUserReference;
import org.xwiki.user.UserProperties;
import org.xwiki.user.UserPropertiesResolver;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;
import org.xwiki.user.internal.DefaultUserProperties;

public abstract class AbstractUserPropertiesResolver
implements UserPropertiesResolver {
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;
    @Inject
    private UserReferenceResolver<CurrentUserReference> currentUserReferenceUserReferenceResolver;

    public UserProperties resolve(UserReference userReference, Object ... parameters) {
        UserReference normalizedUserReference = userReference;
        if (normalizedUserReference == null || CurrentUserReference.INSTANCE == normalizedUserReference) {
            normalizedUserReference = this.currentUserReferenceUserReferenceResolver.resolve(null, parameters);
        }
        DefaultUserProperties userProperties = SuperAdminUserReference.INSTANCE == normalizedUserReference ? new DefaultUserProperties(this.getSuperAdminConfigurationSource()) : (GuestUserReference.INSTANCE == normalizedUserReference ? new DefaultUserProperties(this.getGuestConfigurationSource()) : this.findUserPropertiesResolver(normalizedUserReference).resolve(normalizedUserReference, parameters));
        return userProperties;
    }

    private UserPropertiesResolver findUserPropertiesResolver(UserReference userReference) {
        String hint = String.format("%s/%s", this.getUnderlyingConfigurationSourceHint(), userReference.getClass().getName());
        try {
            return (UserPropertiesResolver)this.componentManager.getInstance(UserPropertiesResolver.class, hint);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException(String.format("Failed to find user properties resolver for role [%s] and hint [%s]", UserPropertiesResolver.class.getName(), hint), e);
        }
    }

    protected abstract String getUnderlyingConfigurationSourceHint();

    protected abstract ConfigurationSource getSuperAdminConfigurationSource();

    protected abstract ConfigurationSource getGuestConfigurationSource();
}

