/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.user.internal;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.mail.internet.InternetAddress;
import org.xwiki.configuration.ConfigurationSaveException;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.user.Editor;
import org.xwiki.user.UserProperties;
import org.xwiki.user.UserType;

public class DefaultUserProperties
implements UserProperties {
    protected Map<String, Object> unsavedProperties = new LinkedHashMap<String, Object>();
    private ConfigurationSource configurationSource;

    public DefaultUserProperties(ConfigurationSource configurationSource) {
        this.configurationSource = configurationSource;
    }

    public boolean displayHiddenDocuments() {
        return this.getProperty("displayHiddenDocuments", Boolean.class, false);
    }

    public void setDisplayHiddenDocuments(boolean displayHiddenDocuments) {
        this.unsavedProperties.put("displayHiddenDocuments", displayHiddenDocuments);
    }

    public boolean isActive() {
        return this.getProperty("active", Boolean.class, false);
    }

    public void setActive(boolean isActive) {
        this.unsavedProperties.put("active", isActive);
    }

    public String getFirstName() {
        return (String)this.getProperty("first_name");
    }

    public void setFirstName(String firstName) {
        this.unsavedProperties.put("first_name", firstName);
    }

    public String getLastName() {
        return (String)this.getProperty("last_name");
    }

    public void setLastName(String lastName) {
        this.unsavedProperties.put("last_name", lastName);
    }

    public InternetAddress getEmail() {
        return this.getProperty("email", InternetAddress.class);
    }

    public void setEmail(InternetAddress emailAddress) {
        this.unsavedProperties.put("email", emailAddress);
    }

    public UserType getType() {
        return UserType.fromString((String)((String)this.getProperty("usertype")));
    }

    public void setType(UserType type) {
        this.unsavedProperties.put("usertype", type);
    }

    public Editor getEditor() {
        return Editor.fromString((String)((String)this.getProperty("editor")));
    }

    public void setEditor(Editor editor) {
        this.unsavedProperties.put("editor", editor);
    }

    public boolean isEmailChecked() {
        return this.getProperty("email_checked", Boolean.class, false);
    }

    public void setEmailChecked(boolean isEmailChecked) {
        this.unsavedProperties.put("email_checked", isEmailChecked);
    }

    public <T> T getProperty(String key, T defaultValue) {
        return (T)this.getConfigurationSource().getProperty(key, defaultValue);
    }

    public <T> T getProperty(String key, Class<T> valueClass) {
        return (T)this.getConfigurationSource().getProperty(key, valueClass);
    }

    public List<String> getKeys() {
        return this.getConfigurationSource().getKeys();
    }

    public boolean containsKey(String key) {
        return this.getConfigurationSource().containsKey(key);
    }

    public boolean isEmpty() {
        return this.getConfigurationSource().isEmpty();
    }

    public <T> T getProperty(String key, Class<T> valueClass, T defaultValue) {
        return (T)this.getConfigurationSource().getProperty(key, valueClass, defaultValue);
    }

    public <T> T getProperty(String key) {
        return (T)this.getConfigurationSource().getProperty(key);
    }

    public void setProperties(Map<String, Object> properties) throws ConfigurationSaveException {
        this.getConfigurationSource().setProperties(properties);
    }

    public void save() throws ConfigurationSaveException {
        this.getConfigurationSource().setProperties(this.unsavedProperties);
        this.unsavedProperties.clear();
    }

    protected ConfigurationSource getConfigurationSource() {
        return this.configurationSource;
    }
}

