/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.user.internal.document;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationRight;
import org.xwiki.configuration.internal.AbstractDocumentConfigurationSourceAuthorization;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.user.CurrentUserReference;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;
import org.xwiki.user.internal.document.DocumentUserReference;

@Component
@Named(value="normaluser")
@Singleton
public class NormalUserConfigurationSourceAuthorization
extends AbstractDocumentConfigurationSourceAuthorization {
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    @Named(value="document")
    private UserReferenceResolver<DocumentReference> documentResolver;
    @Inject
    private UserReferenceResolver<CurrentUserReference> currentResolver;

    protected DocumentReference getDocumentReference() {
        return this.documentAccessBridge.getCurrentUserReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAccess(String key, UserReference userReference, ConfigurationRight right) {
        boolean hasAccess;
        XWikiContext xcontext = (XWikiContext)this.contextProvider.get();
        XWikiDocument currentDocument = xcontext.getDoc();
        if (currentDocument != null) {
            DocumentReference lastAuthorDocumentReference = xcontext.getAuthorReference();
            DocumentReference originalUserReference = this.documentAccessBridge.getCurrentUserReference();
            try {
                xcontext.setUserReference(((DocumentUserReference)userReference).getReference());
                hasAccess = super.hasAccess(key, this.documentResolver.resolve((Object)lastAuthorDocumentReference, new Object[0]), right);
            }
            finally {
                xcontext.setUserReference(originalUserReference);
            }
        } else {
            hasAccess = super.hasAccess(key, this.currentResolver.resolve(null, new Object[0]), right);
        }
        return hasAccess;
    }
}

