/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.user.internal.document;

import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSaveException;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.configuration.internal.AbstractConfigurationSource;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.user.GuestUserReference;
import org.xwiki.user.SuperAdminUserReference;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;

@Component
@Named(value="user")
@Singleton
public class UserPreferencesConfigurationSource
extends AbstractConfigurationSource {
    @Inject
    @Named(value="normaluser")
    private ConfigurationSource normalUserConfigurationSource;
    @Inject
    @Named(value="superadminuser")
    private ConfigurationSource superAdminConfigurationSource;
    @Inject
    @Named(value="guestuser")
    private ConfigurationSource guestConfigurationSource;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    @Named(value="document")
    private UserReferenceResolver<DocumentReference> userReferenceResolver;

    public <T> T getProperty(String key, T defaultValue) {
        return (T)this.getConfigurationSource().getProperty(key, defaultValue);
    }

    public <T> T getProperty(String key, Class<T> valueClass) {
        return (T)this.getConfigurationSource().getProperty(key, valueClass);
    }

    public <T> T getProperty(String key) {
        return (T)this.getConfigurationSource().getProperty(key);
    }

    public List<String> getKeys() {
        return this.getConfigurationSource().getKeys();
    }

    public boolean containsKey(String key) {
        return this.getConfigurationSource().containsKey(key);
    }

    public boolean isEmpty() {
        return this.getConfigurationSource().isEmpty();
    }

    public <T> T getProperty(String key, Class<T> valueClass, T defaultValue) {
        return (T)this.getConfigurationSource().getProperty(key, valueClass, defaultValue);
    }

    public void setProperties(Map<String, Object> properties) throws ConfigurationSaveException {
        this.getConfigurationSource().setProperties(properties);
    }

    private ConfigurationSource getConfigurationSource() {
        UserReference userReference = this.userReferenceResolver.resolve((Object)this.getCurrentUserDocumentReference(), new Object[0]);
        ConfigurationSource configurationSource = SuperAdminUserReference.INSTANCE == userReference ? this.superAdminConfigurationSource : (GuestUserReference.INSTANCE == userReference ? this.guestConfigurationSource : this.normalUserConfigurationSource);
        return configurationSource;
    }

    private DocumentReference getCurrentUserDocumentReference() {
        return this.documentAccessBridge.getCurrentUserReference();
    }
}

