/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.user.internal.group;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.user.api.XWikiGroupService;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.internal.reference.EntityReferenceFactory;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.user.group.GroupException;
import org.xwiki.user.group.GroupManager;
import org.xwiki.user.group.WikiTarget;
import org.xwiki.user.internal.group.AbstractGroupCache;
import org.xwiki.user.internal.group.GroupsCache;
import org.xwiki.user.internal.group.MembersCache;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Singleton
public class DefaultGroupManager
implements GroupManager {
    @Inject
    private GroupsCache groupsCache;
    @Inject
    private MembersCache membersCache;
    @Inject
    private WikiDescriptorManager wikis;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private DocumentReferenceResolver<String> resolver;
    @Inject
    private EntityReferenceFactory referenceFactory;
    @Inject
    private Logger logger;

    private Collection<String> getSearchWikis(DocumentReference reference, WikiTarget wikiTarget, boolean resolve) throws GroupException {
        Collection<Object> cacheWikis;
        switch (wikiTarget) {
            case ENTITY: {
                cacheWikis = Collections.singleton(reference.getWikiReference().getName());
                break;
            }
            case ENTITY_AND_CURRENT: {
                cacheWikis = new TreeSet();
                cacheWikis.add(reference.getWikiReference().getName());
                cacheWikis.add(this.wikis.getCurrentWikiId());
                break;
            }
            default: {
                if (resolve) {
                    try {
                        cacheWikis = this.wikis.getAllIds();
                        break;
                    }
                    catch (WikiManagerException e) {
                        throw new GroupException("Failed to get all wikis", (Throwable)e);
                    }
                }
                cacheWikis = null;
            }
        }
        return cacheWikis;
    }

    private Collection<String> getSearchWikis(DocumentReference reference, Collection<?> wikiTarget, boolean resolve) {
        TreeSet<String> searchWikis = new TreeSet<String>();
        for (Object wiki : wikiTarget) {
            if (wiki instanceof String) {
                searchWikis.add((String)wiki);
                continue;
            }
            if (wiki instanceof WikiReference) {
                searchWikis.add(((WikiReference)wiki).getName());
                continue;
            }
            if (!(wiki instanceof WikiTarget)) continue;
            searchWikis.addAll(this.getSearchWikis(reference, wikiTarget, resolve));
        }
        return searchWikis;
    }

    private Collection<String> getSearchWikis(DocumentReference reference, Object wikiTarget, boolean resolve) throws GroupException {
        Collection<String> cacheWikis;
        if (wikiTarget instanceof WikiTarget) {
            cacheWikis = this.getSearchWikis(reference, (WikiTarget)wikiTarget, resolve);
        } else if (wikiTarget instanceof String) {
            cacheWikis = Collections.singleton((String)wikiTarget);
        } else if (wikiTarget instanceof WikiReference) {
            cacheWikis = Collections.singleton(((WikiReference)wikiTarget).getName());
        } else if (wikiTarget instanceof Collection && !((Collection)wikiTarget).isEmpty()) {
            cacheWikis = this.getSearchWikis(reference, (Collection)wikiTarget, resolve);
        } else if (wikiTarget == null) {
            cacheWikis = this.getSearchWikis(reference, WikiTarget.ALL, resolve);
        } else {
            throw new GroupException("Unsuported wiki target [" + wikiTarget + "] with class [" + wikiTarget.getClass() + "]");
        }
        return cacheWikis;
    }

    public Collection<DocumentReference> getGroups(DocumentReference reference, Object wikiTarget, boolean recurse) throws GroupException {
        return this.getGroups(reference, wikiTarget, recurse, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<DocumentReference> getGroups(DocumentReference reference, Object wikiTarget, boolean recurse, Set<DocumentReference> rootGroups) throws GroupException {
        Collection<String> cacheWikis = this.getSearchWikis(reference, wikiTarget, false);
        AbstractGroupCache.GroupCacheEntry entry = this.groupsCache.getCacheEntry(reference, cacheWikis, true);
        Collection<DocumentReference> groups = this.get(entry, recurse);
        if (groups != null) {
            if (rootGroups != null) {
                rootGroups.addAll(groups);
            }
            return groups;
        }
        AbstractGroupCache.GroupCacheEntry groupCacheEntry = entry;
        synchronized (groupCacheEntry) {
            groups = this.get(entry, recurse);
            if (groups != null) {
                if (rootGroups != null) {
                    rootGroups.addAll(groups);
                }
                return groups;
            }
            groups = entry.getDirect();
            if (groups == null) {
                groups = entry.setDirect(this.getGroups(reference, cacheWikis));
            }
            if (recurse) {
                LinkedHashSet<DocumentReference> resolvedGroups = new LinkedHashSet<DocumentReference>();
                if (rootGroups == null) {
                    rootGroups = resolvedGroups;
                }
                resolvedGroups.add(reference);
                for (DocumentReference group : groups) {
                    if (!rootGroups.contains(group)) {
                        rootGroups.add(group);
                        resolvedGroups.add(group);
                        Collection<DocumentReference> subGRoups = this.getGroups(group, cacheWikis, true, rootGroups);
                        if (subGRoups != null) {
                            resolvedGroups.addAll(subGRoups);
                            continue;
                        }
                        groups = null;
                        continue;
                    }
                    groups = null;
                }
                resolvedGroups.remove(reference);
                if (groups != null || rootGroups == resolvedGroups) {
                    groups = entry.setAll(resolvedGroups);
                }
            } else if (rootGroups != null) {
                rootGroups.addAll(groups);
            }
            return groups;
        }
    }

    private XWikiGroupService getXWikiGroupService(XWikiContext xcontext) throws GroupException {
        try {
            return xcontext.getWiki().getGroupService(xcontext);
        }
        catch (XWikiException e) {
            throw new GroupException("Failed to get group service", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<DocumentReference> getGroups(DocumentReference reference, Object wikiTarget) throws GroupException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiGroupService groupService = this.getXWikiGroupService(xcontext);
        Collection<String> searchWikis = this.getSearchWikis(reference, wikiTarget, true);
        LinkedHashSet<DocumentReference> groups = new LinkedHashSet<DocumentReference>();
        WikiReference currrentWiki = xcontext.getWikiReference();
        for (String wiki : searchWikis) {
            try {
                xcontext.setWikiId(wiki);
                for (DocumentReference groupReference : groupService.getAllGroupsReferencesForMember(reference, -1, 0, xcontext)) {
                    groups.add((DocumentReference)this.referenceFactory.getReference((EntityReference)groupReference));
                }
            }
            catch (XWikiException e) {
                this.logger.error("Failed to get all groups for member [{}] in wiki [{}]", new Object[]{reference, wiki, e});
            }
            finally {
                xcontext.setWikiReference(currrentWiki);
            }
        }
        return groups;
    }

    private Collection<DocumentReference> get(AbstractGroupCache.GroupCacheEntry entry, boolean recurse) {
        Collection<DocumentReference> references = recurse ? entry.getAll() : entry.getDirect();
        return references;
    }

    public Collection<DocumentReference> getMembers(DocumentReference reference, boolean recurse) throws GroupException {
        return this.getMembers(reference, recurse, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<DocumentReference> getMembers(DocumentReference reference, boolean recurse, Set<DocumentReference> rootMembers) throws GroupException {
        AbstractGroupCache.GroupCacheEntry entry = this.membersCache.getCacheEntry(reference, true);
        Collection<DocumentReference> members = this.get(entry, recurse);
        if (members != null) {
            if (rootMembers != null) {
                rootMembers.addAll(members);
            }
            return members;
        }
        AbstractGroupCache.GroupCacheEntry groupCacheEntry = entry;
        synchronized (groupCacheEntry) {
            members = this.get(entry, recurse);
            if (members != null) {
                if (rootMembers != null) {
                    rootMembers.addAll(members);
                }
                return members;
            }
            members = entry.getDirect();
            if (members == null) {
                members = entry.setDirect(this.getMembers(reference));
            }
            if (recurse) {
                LinkedHashSet<DocumentReference> resolvedMembers = new LinkedHashSet<DocumentReference>();
                if (rootMembers == null) {
                    rootMembers = resolvedMembers;
                }
                resolvedMembers.add(reference);
                for (DocumentReference member : members) {
                    if (!rootMembers.contains(member)) {
                        rootMembers.add(member);
                        resolvedMembers.add(member);
                        Collection<DocumentReference> subMembers = this.getMembers(member, true, rootMembers);
                        if (subMembers != null) {
                            resolvedMembers.addAll(subMembers);
                            continue;
                        }
                        members = null;
                        continue;
                    }
                    members = null;
                }
                resolvedMembers.remove(reference);
                if (members != null || rootMembers == resolvedMembers) {
                    members = entry.setAll(resolvedMembers);
                }
            } else if (rootMembers != null) {
                rootMembers.addAll(members);
            }
            return members;
        }
    }

    private Collection<DocumentReference> getMembers(DocumentReference reference) throws GroupException {
        Collection memberStrings;
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiGroupService groupService = this.getXWikiGroupService(xcontext);
        try {
            memberStrings = groupService.getAllMembersNamesForGroup((String)this.serializer.serialize((EntityReference)reference, new Object[0]), -1, 0, xcontext);
        }
        catch (XWikiException e) {
            throw new GroupException("Failed to get members of group [" + reference + "]", (Throwable)e);
        }
        LinkedHashSet<DocumentReference> members = new LinkedHashSet<DocumentReference>();
        for (String memberString : memberStrings) {
            members.add((DocumentReference)this.referenceFactory.getReference((EntityReference)this.resolver.resolve((Object)memberString, new Object[]{reference})));
        }
        return members;
    }
}

