/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.user.internal.group;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.event.XObjectAddedEvent;
import com.xpn.xwiki.internal.event.XObjectDeletedEvent;
import com.xpn.xwiki.internal.event.XObjectEvent;
import com.xpn.xwiki.internal.event.XObjectUpdatedEvent;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseObjectReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.bridge.event.WikiDeletedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.ObjectReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.user.internal.group.GroupsCache;
import org.xwiki.user.internal.group.MembersCache;

@Component
@Named(value="org.xwiki.user.internal.group.GroupInvalidationListener")
@Singleton
public class GroupCacheInvalidationListener
extends AbstractEventListener {
    public static final String NAME = "org.xwiki.user.internal.group.GroupInvalidationListener";
    private static final String GROUPS_CLASSNAME = "XWiki.XWikiGroups";
    private static final String USERS_CLASSNAME = "XWiki.XWikiUsers";
    @Inject
    private DocumentReferenceResolver<String> resolver;
    @Inject
    private GroupsCache groupsCache;
    @Inject
    private MembersCache membersCache;

    public GroupCacheInvalidationListener() {
        super(NAME, new Event[]{new WikiDeletedEvent(), new XObjectDeletedEvent((EntityReference)BaseObjectReference.any((String)GROUPS_CLASSNAME)), new XObjectAddedEvent((EntityReference)BaseObjectReference.any((String)GROUPS_CLASSNAME)), new XObjectUpdatedEvent((EntityReference)BaseObjectReference.any((String)GROUPS_CLASSNAME)), new XObjectDeletedEvent((EntityReference)BaseObjectReference.any((String)USERS_CLASSNAME))});
    }

    public void onEvent(Event event, Object source, Object data) {
        if (event instanceof WikiDeletedEvent) {
            WikiReference wikiReference = new WikiReference(((WikiDeletedEvent)event).getWikiId());
            this.groupsCache.cleanCache(wikiReference.getName());
            this.membersCache.cleanCache(wikiReference.getName());
        } else {
            XWikiDocument document = (XWikiDocument)source;
            DocumentReference documentReference = document.getDocumentReference();
            this.groupsCache.cleanCache(documentReference);
            this.membersCache.cleanCache(documentReference);
            XObjectEvent xobjectEvent = (XObjectEvent)event;
            ObjectReference reference = (ObjectReference)xobjectEvent.getReference();
            BaseObject newXObject = document.getXObject(reference);
            BaseObject previousXObject = document.getOriginalDocument().getXObject(reference);
            this.clean(newXObject, documentReference);
            this.clean(previousXObject, documentReference);
        }
    }

    private void clean(BaseObject xobject, DocumentReference groupReference) {
        if (xobject == null) {
            return;
        }
        String memberString = xobject.getStringValue("member");
        if (StringUtils.isNotEmpty((CharSequence)memberString)) {
            DocumentReference memberReference = this.resolver.resolve((Object)memberString, new Object[]{groupReference});
            this.groupsCache.cleanCache(memberReference);
            this.membersCache.cleanCache(memberReference);
        }
    }
}

