/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.user.script;

import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.script.service.ScriptService;
import org.xwiki.stability.Unstable;
import org.xwiki.user.group.GroupException;
import org.xwiki.user.group.GroupManager;
import org.xwiki.user.group.WikiTarget;

@Component
@Named(value="user.group")
@Singleton
@Unstable
public class GroupScriptService
implements ScriptService {
    public static final String ROLEHINT = "user.group";
    @Inject
    private GroupManager groupManager;

    public Collection<DocumentReference> getGroups(DocumentReference member, Object wikiTarget, boolean recurse) throws GroupException {
        return this.groupManager.getGroups(member, wikiTarget, recurse);
    }

    public Collection<DocumentReference> getGroupsFromAllWikis(DocumentReference member) throws GroupException {
        return this.getGroups(member, null, true);
    }

    public Collection<DocumentReference> getGroupsFromMemberWiki(DocumentReference member) throws GroupException {
        return this.getGroups(member, WikiTarget.ENTITY, true);
    }

    public Collection<DocumentReference> getGroupsFromMemberAndCurrentWiki(DocumentReference member) throws GroupException {
        return this.getGroups(member, WikiTarget.ENTITY_AND_CURRENT, true);
    }

    public Collection<DocumentReference> getMembers(DocumentReference group, boolean recurse) throws GroupException {
        return this.groupManager.getMembers(group, recurse);
    }

    public Collection<DocumentReference> getMembers(DocumentReference group) throws GroupException {
        return this.getMembers(group, true);
    }
}

