/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.user.script;

import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.script.service.ScriptService;
import org.xwiki.stability.Unstable;
import org.xwiki.user.group.GroupException;
import org.xwiki.user.group.GroupManager;
import org.xwiki.user.group.WikiTarget;

@Component
@Named(value="user.group")
@Singleton
public class GroupScriptService
implements ScriptService {
    public static final String ROLEHINT = "user.group";
    @Inject
    private GroupManager groupManager;
    @Inject
    private Logger logger;

    public Collection<DocumentReference> getGroups(DocumentReference member, Object wikiTarget, boolean recurse) throws GroupException {
        return this.groupManager.getGroups(member, wikiTarget, recurse);
    }

    public Collection<DocumentReference> getGroupsFromAllWikis(DocumentReference member) throws GroupException {
        return this.getGroups(member, null, true);
    }

    public Collection<DocumentReference> getGroupsFromMemberWiki(DocumentReference member) throws GroupException {
        return this.getGroups(member, WikiTarget.ENTITY, true);
    }

    public Collection<DocumentReference> getGroupsFromMemberAndCurrentWiki(DocumentReference member) throws GroupException {
        return this.getGroups(member, WikiTarget.ENTITY_AND_CURRENT, true);
    }

    public Collection<DocumentReference> getMembers(DocumentReference group, boolean recurse) throws GroupException {
        return this.groupManager.getMembers(group, recurse);
    }

    public Collection<DocumentReference> getMembers(DocumentReference group) throws GroupException {
        return this.getMembers(group, true);
    }

    @Unstable
    public boolean canAddGroupAsMember(DocumentReference candidate, DocumentReference target) {
        boolean ret;
        if (target == null || candidate == null || candidate.equals((Object)target)) {
            ret = false;
        } else {
            try {
                if (this.getMembers(target, false).contains(candidate)) {
                    ret = false;
                } else {
                    try {
                        ret = !this.getMembers(candidate, true).contains(target);
                    }
                    catch (GroupException e) {
                        this.logger.warn("Failed to access the members of the candidate group [{}]", (Object)candidate, (Object)e);
                        ret = false;
                    }
                }
            }
            catch (GroupException e) {
                this.logger.warn("Failed to access the members of the target group [{}]", (Object)target, (Object)e);
                ret = false;
            }
        }
        return ret;
    }
}

