/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.user.script;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.script.service.ScriptService;
import org.xwiki.script.service.ScriptServiceManager;
import org.xwiki.stability.Unstable;
import org.xwiki.user.CurrentUserReference;
import org.xwiki.user.GuestUserReference;
import org.xwiki.user.SuperAdminUserReference;
import org.xwiki.user.UserManager;
import org.xwiki.user.UserProperties;
import org.xwiki.user.UserPropertiesResolver;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;

@Component
@Named(value="user")
@Singleton
public class UserScriptService
implements ScriptService {
    public static final String ROLEHINT = "user";
    @Inject
    @Named(value="secure")
    private UserPropertiesResolver userPropertiesResolver;
    @Inject
    @Named(value="secure/all")
    private UserPropertiesResolver allUserPropertiesResolver;
    @Inject
    private ScriptServiceManager scriptServiceManager;
    @Inject
    private UserManager userManager;
    @Inject
    private UserReferenceResolver<String> userReferenceResolver;

    public <S extends ScriptService> S get(String serviceName) {
        return (S)this.scriptServiceManager.get("user." + serviceName);
    }

    @Unstable
    public UserProperties getProperties(UserReference userReference, Object ... parameters) {
        return this.userPropertiesResolver.resolve(userReference, parameters);
    }

    @Unstable
    public UserProperties getProperties(String userReference, Object ... parameters) {
        return this.userPropertiesResolver.resolve(this.userReferenceResolver.resolve((Object)userReference, new Object[0]), parameters);
    }

    @Unstable
    public UserProperties getProperties(Object ... parameters) {
        return this.userPropertiesResolver.resolve((UserReference)CurrentUserReference.INSTANCE, parameters);
    }

    @Unstable
    public UserProperties getProperties() {
        return this.userPropertiesResolver.resolve((UserReference)CurrentUserReference.INSTANCE, new Object[0]);
    }

    @Unstable
    public UserProperties getAllProperties(UserReference userReference, Object ... parameters) {
        return this.allUserPropertiesResolver.resolve(userReference, parameters);
    }

    @Unstable
    public UserProperties getAllProperties(Object ... parameters) {
        return this.allUserPropertiesResolver.resolve((UserReference)CurrentUserReference.INSTANCE, parameters);
    }

    @Unstable
    public UserProperties getAllProperties() {
        return this.allUserPropertiesResolver.resolve((UserReference)CurrentUserReference.INSTANCE, new Object[0]);
    }

    @Unstable
    public UserReference getGuestUserReference() {
        return GuestUserReference.INSTANCE;
    }

    @Unstable
    public UserReference getSuperAdminUserReference() {
        return SuperAdminUserReference.INSTANCE;
    }

    @Unstable
    public UserReference getCurrentUserReference() {
        return CurrentUserReference.INSTANCE;
    }

    @Unstable
    public boolean exists(UserReference userReference) {
        return this.userManager.exists(userReference);
    }
}

