/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.vfs;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.resource.ResourceType;
import org.xwiki.resource.entity.EntityResourceAction;
import org.xwiki.resource.entity.EntityResourceReference;
import org.xwiki.text.XWikiToStringBuilder;

public class VfsResourceReference
extends EntityResourceReference {
    public static final ResourceType TYPE = new ResourceType("vfs");
    private static final String RESOURCE_PATH_SEPARATOR = "/";
    private URI uri;
    private List<String> pathSegments;

    public VfsResourceReference(URI uri, List<String> pathSegments) {
        super((EntityReference)new WikiReference("xwiki"), EntityResourceAction.fromString((String)""));
        this.setType(TYPE);
        this.uri = uri;
        this.pathSegments = new ArrayList<String>(pathSegments);
    }

    public VfsResourceReference(URI uri, String pathSegments) {
        this(uri, Arrays.asList(StringUtils.split((String)pathSegments, (String)RESOURCE_PATH_SEPARATOR)));
    }

    public VfsResourceReference(URI fullURI) {
        this(URI.create(StringUtils.substringBefore((String)fullURI.toString(), (String)RESOURCE_PATH_SEPARATOR)), StringUtils.substringAfter((String)fullURI.toString(), (String)RESOURCE_PATH_SEPARATOR));
    }

    public URI getURI() {
        return this.uri;
    }

    public List<String> getPathSegments() {
        return this.pathSegments;
    }

    public String getPath() {
        return StringUtils.join(this.getPathSegments(), (String)RESOURCE_PATH_SEPARATOR);
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 7).append((Object)this.getURI()).append(this.getPathSegments()).append((Object)this.getType()).append((Object)this.getParameters()).toHashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        VfsResourceReference rhs = (VfsResourceReference)((Object)object);
        return new EqualsBuilder().append((Object)this.getURI(), (Object)rhs.getURI()).append(this.getPathSegments(), rhs.getPathSegments()).append((Object)this.getType(), (Object)rhs.getType()).append((Object)this.getParameters(), (Object)rhs.getParameters()).isEquals();
    }

    public String toString() {
        XWikiToStringBuilder builder = new XWikiToStringBuilder((Object)this);
        builder.append("uri", (Object)this.getURI());
        builder.append("path", (Object)this.getPath());
        builder.append("parameters", (Object)this.getParameters());
        return builder.toString();
    }

    public URI toURI() {
        return URI.create(String.format("%s/%s", this.getURI().toString(), this.getPath()));
    }
}

