/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.vfs.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.vfs.VfsException;
import org.xwiki.vfs.VfsPermissionChecker;
import org.xwiki.vfs.VfsResourceReference;

@Component
@Named(value="cascading")
@Singleton
public class CascadingVfsPermissionChecker
implements VfsPermissionChecker {
    static final String HINT = "cascading";
    @Inject
    private Provider<ComponentManager> componentManagerProvider;

    @Override
    public void checkPermission(VfsResourceReference resourceReference) throws VfsException {
        VfsPermissionChecker resolvedChecker;
        String scheme = resourceReference.getURI().getScheme();
        if (HINT.equals(scheme)) {
            throw new VfsException(String.format("[%s] is a reserved VFS URI scheme and cannot be used.", HINT));
        }
        ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
        try {
            resolvedChecker = (VfsPermissionChecker)componentManager.getInstance(VfsPermissionChecker.class, scheme);
        }
        catch (ComponentLookupException e) {
            try {
                resolvedChecker = (VfsPermissionChecker)componentManager.getInstance(VfsPermissionChecker.class);
            }
            catch (ComponentLookupException ee) {
                throw new VfsException(String.format("No VFS Permission Checked has been found in the system. Refusing access to VFS URI scheme [%s]", scheme), ee);
            }
        }
        resolvedChecker.checkPermission(resourceReference);
    }
}

